/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.core.util;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class StrUtil {
    private static final long KB_IN_BYTES = 1024L;
    private static final long MB_IN_BYTES = 0x100000L;
    private static final long GB_IN_BYTES = 0x40000000L;
    private static final long TB_IN_BYTES = 0x10000000000L;
    private static final DecimalFormat df = new DecimalFormat("0.00");
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("(\\$)\\{?(\\w+)\\}?");
    private static String SYSTEM_ENCODING = System.getProperty("file.encoding");

    private StrUtil() {
    }

    public static String stringify(long byteNumber) {
        if (byteNumber / 0x10000000000L > 0L) {
            return df.format((double)byteNumber / 1.099511627776E12) + "TB";
        }
        if (byteNumber / 0x40000000L > 0L) {
            return df.format((double)byteNumber / 1.073741824E9) + "GB";
        }
        if (byteNumber / 0x100000L > 0L) {
            return df.format((double)byteNumber / 1048576.0) + "MB";
        }
        if (byteNumber / 1024L > 0L) {
            return df.format((double)byteNumber / 1024.0) + "KB";
        }
        return String.valueOf(byteNumber) + "B";
    }

    public static String replaceVariable(String param) {
        HashMap<String, String> mapping = new HashMap<String, String>();
        Matcher matcher = VARIABLE_PATTERN.matcher(param);
        while (matcher.find()) {
            String variable = matcher.group(2);
            String value = System.getProperty(variable);
            if (StringUtils.isBlank((CharSequence)value)) {
                value = matcher.group();
            }
            mapping.put(matcher.group(), value);
        }
        String retString = param;
        for (String key : mapping.keySet()) {
            retString = retString.replace(key, (CharSequence)mapping.get(key));
        }
        return retString;
    }

    public static String compressMiddle(String s, int headLength, int tailLength) {
        Validate.notNull((Object)s, (String)"Input string must not be null", (Object[])new Object[0]);
        Validate.isTrue((headLength > 0 ? 1 : 0) != 0, (String)"Head length must be larger than 0", (Object[])new Object[0]);
        Validate.isTrue((tailLength > 0 ? 1 : 0) != 0, (String)"Tail length must be larger than 0", (Object[])new Object[0]);
        if (headLength + tailLength >= s.length()) {
            return s;
        }
        return s.substring(0, headLength) + "..." + s.substring(s.length() - tailLength);
    }

    static {
        if (SYSTEM_ENCODING == null) {
            SYSTEM_ENCODING = "UTF-8";
        }
    }
}

