/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.core.util;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public final class RangeSplitUtil {
    public static String[] doAsciiStringSplit(String left, String right, int expectSliceNumber) {
        int radix = 128;
        BigInteger[] tempResult = RangeSplitUtil.doBigIntegerSplit(RangeSplitUtil.stringToBigInteger(left, radix), RangeSplitUtil.stringToBigInteger(right, radix), expectSliceNumber);
        String[] result = new String[tempResult.length];
        result[0] = left;
        result[tempResult.length - 1] = right;
        int len = tempResult.length - 1;
        for (int i = 1; i < len; ++i) {
            result[i] = RangeSplitUtil.bigIntegerToString(tempResult[i], radix);
        }
        return result;
    }

    public static long[] doLongSplit(long left, long right, int expectSliceNumber) {
        BigInteger[] result = RangeSplitUtil.doBigIntegerSplit(BigInteger.valueOf(left), BigInteger.valueOf(right), expectSliceNumber);
        long[] returnResult = new long[result.length];
        int len = result.length;
        for (int i = 0; i < len; ++i) {
            returnResult[i] = result[i].longValue();
        }
        return returnResult;
    }

    public static BigInteger[] doBigIntegerSplit(BigInteger left, BigInteger right, int expectSliceNumber) {
        if (expectSliceNumber < 1) {
            throw new IllegalArgumentException(String.format("\u5207\u5206\u4efd\u6570\u4e0d\u80fd\u5c0f\u4e8e1. \u6b64\u5904:expectSliceNumber=[%s].", expectSliceNumber));
        }
        if (null == left || null == right) {
            throw new IllegalArgumentException(String.format("\u5bf9 BigInteger \u8fdb\u884c\u5207\u5206\u65f6\uff0c\u5176\u5de6\u53f3\u533a\u95f4\u4e0d\u80fd\u4e3a null. \u6b64\u5904:left=[%s],right=[%s].", left, right));
        }
        if (left.compareTo(right) == 0) {
            return new BigInteger[]{left, right};
        }
        if (left.compareTo(right) > 0) {
            BigInteger temp = left;
            left = right;
            right = temp;
        }
        BigInteger endAndStartGap = right.subtract(left);
        BigInteger step = endAndStartGap.divide(BigInteger.valueOf(expectSliceNumber));
        BigInteger remainder = endAndStartGap.remainder(BigInteger.valueOf(expectSliceNumber));
        if (step.compareTo(BigInteger.ZERO) == 0) {
            expectSliceNumber = remainder.intValue();
        }
        BigInteger[] result = new BigInteger[expectSliceNumber + 1];
        result[0] = left;
        result[expectSliceNumber] = right;
        BigInteger upperBound = left;
        for (int i = 1; i < expectSliceNumber; ++i) {
            BigInteger lowerBound = upperBound;
            upperBound = lowerBound.add(step);
            result[i] = upperBound = upperBound.add(remainder.compareTo(BigInteger.valueOf(i)) >= 0 ? BigInteger.ONE : BigInteger.ZERO);
        }
        return result;
    }

    private static void checkIfBetweenRange(int value, int left, int right) {
        if (value < left || value > right) {
            throw new IllegalArgumentException(String.format("parameter can not <[%s] or >[%s].", left, right));
        }
    }

    public static BigInteger stringToBigInteger(String aString, int radix) {
        if (null == aString) {
            throw new IllegalArgumentException("\u53c2\u6570 bigInteger \u4e0d\u80fd\u4e3a\u7a7a.");
        }
        RangeSplitUtil.checkIfBetweenRange(radix, 1, 128);
        BigInteger result = BigInteger.ZERO;
        BigInteger radixBigInteger = BigInteger.valueOf(radix);
        int k = 0;
        for (int i = aString.length() - 1; i >= 0; --i) {
            char tempChar = aString.charAt(i);
            if (tempChar >= '\u0080') {
                throw new IllegalArgumentException(String.format("\u6839\u636e\u5b57\u7b26\u4e32\u8fdb\u884c\u5207\u5206\u65f6\u4ec5\u652f\u6301 ASCII \u5b57\u7b26\u4e32\uff0c\u800c\u5b57\u7b26\u4e32:[%s]\u975e ASCII \u5b57\u7b26\u4e32.", aString));
            }
            result = result.add(BigInteger.valueOf(tempChar).multiply(radixBigInteger.pow(k)));
            ++k;
        }
        return result;
    }

    private static String bigIntegerToString(BigInteger bigInteger, int radix) {
        if (null == bigInteger) {
            throw new IllegalArgumentException("\u53c2\u6570 bigInteger \u4e0d\u80fd\u4e3a\u7a7a.");
        }
        RangeSplitUtil.checkIfBetweenRange(radix, 1, 128);
        StringBuilder resultStringBuilder = new StringBuilder();
        ArrayList<Integer> list = new ArrayList<Integer>();
        BigInteger radixBigInteger = BigInteger.valueOf(radix);
        BigInteger currentValue = bigInteger;
        BigInteger quotient = currentValue.divide(radixBigInteger);
        while (quotient.compareTo(BigInteger.ZERO) > 0) {
            list.add(currentValue.remainder(radixBigInteger).intValue());
            quotient = currentValue = currentValue.divide(radixBigInteger);
        }
        Collections.reverse(list);
        if (list.isEmpty()) {
            list.add(0, bigInteger.remainder(radixBigInteger).intValue());
        }
        HashMap<Integer, Character> map = new HashMap<Integer, Character>();
        for (int i = 0; i < radix; ++i) {
            map.put(i, Character.valueOf((char)i));
        }
        for (Integer aList : list) {
            resultStringBuilder.append(map.get(aList));
        }
        return resultStringBuilder.toString();
    }

    public static Pair<Character, Character> getMinAndMaxCharacter(String aString) {
        char min;
        if (!RangeSplitUtil.isPureAscii(aString)) {
            throw new IllegalArgumentException(String.format("\u6839\u636e\u5b57\u7b26\u4e32\u8fdb\u884c\u5207\u5206\u65f6\u4ec5\u652f\u6301 ASCII \u5b57\u7b26\u4e32\uff0c\u800c\u5b57\u7b26\u4e32:[%s]\u975e ASCII \u5b57\u7b26\u4e32.", aString));
        }
        char max = min = aString.charAt(0);
        int len = aString.length();
        for (int i = 1; i < len; ++i) {
            char temp = aString.charAt(i);
            min = min < temp ? min : temp;
            max = max > temp ? max : temp;
        }
        return new ImmutablePair((Object)Character.valueOf(min), (Object)Character.valueOf(max));
    }

    private static boolean isPureAscii(String aString) {
        if (null == aString) {
            return false;
        }
        int len = aString.length();
        for (int i = 0; i < len; ++i) {
            char ch = aString.charAt(i);
            if (ch < '\u007f' && ch >= '\u0000') continue;
            return false;
        }
        return true;
    }
}

