/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.core.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import risesoft.data.transfer.core.util.FileUtils;

public class ClassTools {
    public static List<Class<?>> getClasses(String pack) {
        ArrayList list = new ArrayList();
        boolean recursive = true;
        String packageName = pack;
        String packageDirName = packageName.replace('.', '/');
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    ClassTools.findAndAddClassesInPackageByFile(packageName, filePath, recursive, list);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                try {
                    JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String name = entry.getName();
                        if (name.charAt(0) == '/') {
                            name = name.substring(1);
                        }
                        if (!name.startsWith(packageDirName)) continue;
                        int idx = name.lastIndexOf(47);
                        if (idx != -1) {
                            packageName = name.substring(0, idx).replace('/', '.');
                        }
                        if (idx == -1 && !recursive || !name.endsWith(".class") || entry.isDirectory()) continue;
                        String className = name.substring(packageName.length() + 1, name.length() - 6);
                        try {
                            if (packageName == null || "".equals(packageName)) continue;
                            list.add(Class.forName(packageName + "." + className));
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static List<Class<?>> getJarsFileClass(String rootPath) throws Exception {
        File file = new File(rootPath);
        if (file.isDirectory()) {
            ArrayList classes = new ArrayList();
            List<File> childrens = FileUtils.getChildrens(file);
            for (File children : childrens) {
                if (!children.getName().endsWith(".jar")) continue;
                classes.addAll(ClassTools.getJarFileClass(new FileInputStream(children)));
            }
            return classes;
        }
        return ClassTools.getJarFileClass(new FileInputStream(file));
    }

    public static List<Class<?>> getJarFileClass(InputStream inputStream) throws Exception {
        JarInputStream jarInputStream = new JarInputStream(inputStream);
        ArrayList res = new ArrayList();
        final HashMap<String, int[]> classByteMap = new HashMap<String, int[]>();
        final byte[] buffer = new byte[inputStream.available() * 3];
        int head = 0;
        int chunk = 256;
        JarEntry jarEntry = jarInputStream.getNextJarEntry();
        while (jarEntry != null) {
            String name = jarEntry.getName();
            if (name.endsWith(".class")) {
                int read;
                String className = name.replaceAll("/", ".").replaceAll(".class", "");
                int size = 0;
                while ((read = jarInputStream.read(buffer, head + size, chunk)) != -1) {
                    size += read;
                }
                classByteMap.put(className, new int[]{head, size});
                head += size;
            }
            jarEntry = jarInputStream.getNextJarEntry();
        }
        SecureClassLoader classLoader = new SecureClassLoader(){

            @Override
            protected Class<?> findClass(String name) {
                int[] arr = (int[])classByteMap.get(name);
                return super.defineClass(name, buffer, arr[0], arr[1]);
            }
        };
        for (String name : classByteMap.keySet()) {
            res.add(classLoader.loadClass(name));
        }
        return res;
    }

    public static Set<Class<?>> getInterfaceClass(Class<?> cla) {
        HashSet interfaceCla = new HashSet();
        ClassTools.loadInterfaceClass(cla, interfaceCla);
        return interfaceCla;
    }

    public static <T> List<T> getInstancesOfPack(String packName, Class<T> retClass) throws Exception {
        List<Class<?>> classes = ClassTools.getClasses(packName);
        ArrayList<T> resList = new ArrayList<T>();
        for (Class<?> cls : classes) {
            if (!retClass.isAssignableFrom(cls)) continue;
            resList.add(retClass.cast(cls.newInstance()));
        }
        return resList;
    }

    private static void loadInterfaceClass(Class<?> cla, Set<Class<?>> classes) {
        Class<?>[] interfaces;
        Class<?> superclass = cla.getSuperclass();
        if (superclass != null && superclass != Object.class) {
            ClassTools.loadInterfaceClass(superclass, classes);
        }
        if ((interfaces = cla.getInterfaces()).length == 0) {
            return;
        }
        for (Class<?> anInterface : interfaces) {
            classes.add(anInterface);
            ClassTools.loadInterfaceClass(anInterface, classes);
        }
    }

    public static void findAndAddClassesInPackageByFile(String packageName, String packagePath, final boolean recursive, List<Class<?>> classes) {
        File[] dirfiles;
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file : dirfiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return recursive && file.isDirectory() || file.getName().endsWith(".class");
            }
        })) {
            if (file.isDirectory()) {
                ClassTools.findAndAddClassesInPackageByFile(packageName + "." + file.getName(), file.getAbsolutePath(), recursive, classes);
                continue;
            }
            String className = file.getName().substring(0, file.getName().length() - 6);
            try {
                classes.add(Thread.currentThread().getContextClassLoader().loadClass(packageName + "." + className));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }
}

