/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.core.statistics;

import java.text.DecimalFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import risesoft.data.transfer.core.context.JobContext;
import risesoft.data.transfer.core.record.Record;
import risesoft.data.transfer.core.statistics.Communication;
import risesoft.data.transfer.core.statistics.State;
import risesoft.data.transfer.core.util.StrUtil;

public final class CommunicationTool {
    public static final String STAGE = "stage";
    public static final String BYTE_SPEED = "byteSpeed";
    public static final String RECORD_SPEED = "recordSpeed";
    public static final String PERCENTAGE = "percentage";
    public static final String READ_SUCCEED_RECORDS = "readSucceedRecords";
    public static final String READ_SUCCEED_BYTES = "readSucceedBytes";
    public static final String READ_FAILED_RECORDS = "readFailedRecords";
    public static final String READ_FAILED_BYTES = "readFailedBytes";
    public static final String WRITE_RECEIVED_RECORDS = "writeReceivedRecords";
    public static final String WRITE_RECEIVED_BYTES = "writeReceivedBytes";
    public static final String WRITE_FAILED_RECORDS = "writeFailedRecords";
    public static final String WRITE_FAILED_BYTES = "writeFailedBytes";
    private static final String WRITE_SUCCEED_RECORDS = "writeSucceedRecords";
    private static final String WRITE_SUCCEED_BYTES = "writeSucceedBytes";
    public static final String READ_JOB_END = "readJobEnd";
    public static final String READ_JOB_START = "readJobStart";
    public static final String WRITER_JOB_END = "writerJobEnd";
    public static final String WRITER_JOB_START = "writerJobStart";

    public static Communication getReportCommunication(Communication now, Communication old, int totalStage) {
        Validate.isTrue((now != null && old != null ? 1 : 0) != 0, (String)"\u4e3a\u6c47\u62a5\u51c6\u5907\u7684\u65b0\u65e7metric\u4e0d\u80fd\u4e3anull", (Object[])new Object[0]);
        long totalReadRecords = CommunicationTool.getTotalReadRecords(now);
        long totalReadBytes = CommunicationTool.getTotalReadBytes(now);
        now.setLongCounter(WRITE_SUCCEED_RECORDS, CommunicationTool.getWriteSucceedRecords(now));
        now.setLongCounter(WRITE_SUCCEED_BYTES, CommunicationTool.getWriteSucceedBytes(now));
        long timeInterval = now.getTimestamp() - old.getTimestamp();
        long sec = timeInterval <= 1000L ? 1L : timeInterval / 1000L;
        long bytesSpeed = (totalReadBytes - CommunicationTool.getTotalReadBytes(old)) / sec;
        long recordsSpeed = (totalReadRecords - CommunicationTool.getTotalReadRecords(old)) / sec;
        now.setLongCounter(BYTE_SPEED, bytesSpeed < 0L ? 0L : bytesSpeed);
        now.setLongCounter(RECORD_SPEED, recordsSpeed < 0L ? 0L : recordsSpeed);
        now.setDoubleCounter(PERCENTAGE, (double)now.getLongCounter(STAGE).longValue() / (double)totalStage);
        if (old.getThrowable() != null) {
            now.setThrowable(old.getThrowable());
        }
        return now;
    }

    public static long getTotalReadRecords(Communication communication) {
        return communication.getLongCounter(READ_SUCCEED_RECORDS) + communication.getLongCounter(READ_FAILED_RECORDS);
    }

    public static long getTotalReadBytes(Communication communication) {
        return communication.getLongCounter(READ_SUCCEED_BYTES) + communication.getLongCounter(READ_FAILED_BYTES);
    }

    public static String getStatistics(Communication communication) {
        long transferCosts = (communication.getEndTime() - communication.getStartTime()) / 1000L;
        if (0L == transferCosts) {
            transferCosts = 1L;
        }
        long byteSpeedPerSecond = communication.getLongCounter(READ_SUCCEED_BYTES) / transferCosts;
        long recordSpeedPerSecond = communication.getLongCounter(READ_SUCCEED_RECORDS) / transferCosts;
        return String.format("\n%-26s: %19s\n%-26s: %-18s\n%-26s: %-18s\n%-26s: %19s\n%-26s: %19s\n%-26s: %19s\n%-26s: %19s\n%-26s: %19s\n%-26s: %19s\n%-26s: %19s\n", "\u4efb\u52a1\u603b\u6d41\u91cf", StrUtil.stringify(communication.getLongCounter(READ_SUCCEED_BYTES)), "\u4efb\u52a1\u542f\u52a8\u65f6\u523b", DateFormatUtils.format((Date)new Date(communication.getStartTime()), (String)"yyyy-MM-dd HH:mm:ss"), "\u4efb\u52a1\u7ed3\u675f\u65f6\u523b", DateFormatUtils.format((Date)new Date(communication.getEndTime()), (String)"yyyy-MM-dd HH:mm:ss"), "\u4efb\u52a1\u8f93\u5165\u60c5\u51b5", String.format("%s-%s %s/s", DateFormatUtils.format((Date)new Date(communication.getLongCounter(READ_JOB_START)), (String)"HH:mm:ss"), DateFormatUtils.format((Date)new Date(communication.getLongCounter(READ_JOB_END)), (String)"HH:mm:ss"), (communication.getLongCounter(READ_JOB_END) - communication.getLongCounter(READ_JOB_START)) / 1000L), "\u4efb\u52a1\u8f93\u51fa\u60c5\u51b5", String.format("%s-%s %d/s", DateFormatUtils.format((Date)new Date(communication.getLongCounter(WRITER_JOB_START)), (String)"HH:mm:ss"), DateFormatUtils.format((Date)new Date(communication.getLongCounter(WRITER_JOB_END)), (String)"HH:mm:ss"), (communication.getLongCounter(WRITER_JOB_END) - communication.getLongCounter(WRITER_JOB_START)) / 1000L), "\u4efb\u52a1\u603b\u8ba1\u8017\u65f6", transferCosts + "s", "\u4efb\u52a1\u5e73\u5747\u6d41\u91cf", StrUtil.stringify(byteSpeedPerSecond) + "/s", "\u8bb0\u5f55\u5199\u5165\u901f\u5ea6", String.valueOf(recordSpeedPerSecond) + "rec/s", "\u8bfb\u51fa\u8bb0\u5f55\u603b\u6570", String.valueOf(CommunicationTool.getTotalReadRecords(communication)), "\u8bfb\u5199\u5931\u8d25\u603b\u6570", String.valueOf(CommunicationTool.getTotalErrorRecords(communication)));
    }

    public static long getTotalErrorRecords(Communication communication) {
        return communication.getLongCounter(READ_FAILED_RECORDS) + communication.getLongCounter(WRITE_FAILED_RECORDS);
    }

    public static long getRecordSize(List<Record> records, int start, int end) {
        long size = 0L;
        for (int i = start; i < end; ++i) {
            size += (long)records.get(i).getByteSize();
        }
        return size;
    }

    public static long getRecordSize(List<Record> records) {
        return CommunicationTool.getRecordSize(records, 0, records.size());
    }

    public static long getTotalErrorBytes(Communication communication) {
        return communication.getLongCounter(READ_FAILED_BYTES) + communication.getLongCounter(WRITE_FAILED_BYTES);
    }

    public static long getWriteSucceedRecords(Communication communication) {
        return communication.getLongCounter(WRITE_RECEIVED_RECORDS) - communication.getLongCounter(WRITE_FAILED_RECORDS);
    }

    public static long getWriteSucceedBytes(Communication communication) {
        return communication.getLongCounter(WRITE_RECEIVED_BYTES) - communication.getLongCounter(WRITE_FAILED_BYTES);
    }

    public static String getStatus(State state) {
        switch (state) {
            case RUNNING: {
                return "\u8fd0\u884c\u4e2d";
            }
            case WAITING: {
                return "\u4f11\u7720\u4e2d";
            }
            case FAILED: {
                return "\u6267\u884c\u5931\u8d25";
            }
            case SUCCEEDED: {
                return "\u6210\u529f\u4e86";
            }
        }
        return "\u672a\u77e5";
    }

    public static String getStateInfo(Communication communication, JobContext jobContext) {
        return String.format("\u4efb\u52a1\u72b6\u6001:%s       | \u8f93\u5165\u6570\u636e\u603b\u91cf:%d/record %d/byte     | \u8f93\u51fa\u6570\u636e\u603b\u91cf:%d/record %d/byte     | \u5269\u4f59\u8f93\u5165\u4efb\u52a1:  %d       |\u5269\u4f59\u8f93\u51fa\u4efb\u52a1: %d       | \u8017\u65f6: %d/s ", CommunicationTool.getStatus(communication.getState()), communication.getLongCounter(READ_SUCCEED_RECORDS), communication.getLongCounter(READ_SUCCEED_BYTES), communication.getLongCounter(WRITE_SUCCEED_RECORDS), communication.getLongCounter(WRITE_SUCCEED_BYTES), jobContext.getInExecutorTaskQueue().getResidueSize(), jobContext.getOutExecutorTaskQueue().getResidueSize(), (System.currentTimeMillis() - communication.getStartTime()) / 1000L);
    }

    public static class Stringify {
        private static final DecimalFormat df = new DecimalFormat("0.00");

        private static String getSpeed(Communication communication) {
            return String.format("%s/s, %d records/s", StrUtil.stringify(communication.getLongCounter(CommunicationTool.BYTE_SPEED)), communication.getLongCounter(CommunicationTool.RECORD_SPEED));
        }

        public static String unitTime(long time) {
            return Stringify.unitTime(time, TimeUnit.NANOSECONDS);
        }

        public static String unitTime(long time, TimeUnit timeUnit) {
            return String.format("%,.3fs", Float.valueOf((float)timeUnit.toNanos(time) / 1.0E9f));
        }

        public static String unitSize(long size) {
            if (size > 1000000000L) {
                return String.format("%,.2fG", Float.valueOf((float)size / 1.0E9f));
            }
            if (size > 1000000L) {
                return String.format("%,.2fM", Float.valueOf((float)size / 1000000.0f));
            }
            if (size > 1000L) {
                return String.format("%,.2fK", Float.valueOf((float)size / 1000.0f));
            }
            return size + "B";
        }

        private static String getPercentage(Communication communication) {
            return df.format(communication.getDoubleCounter(CommunicationTool.PERCENTAGE) * 100.0) + "%";
        }
    }
}

