/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.core.statistics;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import risesoft.data.transfer.core.statistics.State;

public class Communication
implements Cloneable {
    private Map<String, Number> counter;
    private State state;
    private Throwable throwable;
    private long timestamp;
    private long startTime;
    private long endTime;
    Map<String, List<String>> message;

    public Communication() {
        this.init();
    }

    public synchronized void reset() {
        this.init();
    }

    private void init() {
        this.counter = new ConcurrentHashMap<String, Number>();
        this.state = State.RUNNING;
        this.throwable = null;
        this.message = new ConcurrentHashMap<String, List<String>>();
        this.timestamp = System.currentTimeMillis();
        this.startTime = System.currentTimeMillis();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public Map<String, Number> getCounter() {
        return this.counter;
    }

    public State getState() {
        return this.state;
    }

    public synchronized void setState(State state, boolean isForce) {
        if (!isForce && this.state.equals(State.FAILED)) {
            return;
        }
        this.state = state;
        if (this.isFinished()) {
            this.endTime = System.currentTimeMillis();
        }
    }

    public synchronized void setState(State state) {
        this.setState(state, false);
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public synchronized String getThrowableMessage() {
        return this.throwable == null ? "" : this.throwable.getMessage();
    }

    public void setThrowable(Throwable throwable) {
        this.setThrowable(throwable, false);
    }

    public synchronized void setThrowable(Throwable throwable, boolean isForce) {
        this.throwable = isForce ? throwable : (this.throwable == null ? throwable : this.throwable);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public Map<String, List<String>> getMessage() {
        return this.message;
    }

    public List<String> getMessage(String key) {
        return this.message.get(key);
    }

    public synchronized void addMessage(String key, String value) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)key), (String)"\u589e\u52a0message\u7684key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<String> valueList = this.message.get(key);
        if (null == valueList) {
            valueList = new ArrayList<String>();
            this.message.put(key, valueList);
        }
        valueList.add(value);
    }

    public synchronized Long getLongCounter(String key) {
        Number value = this.counter.get(key);
        return value == null ? 0L : value.longValue();
    }

    public synchronized void setLongCounter(String key, long value) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)key), (String)"\u8bbe\u7f6ecounter\u7684key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.counter.put(key, value);
    }

    public synchronized Double getDoubleCounter(String key) {
        Number value = this.counter.get(key);
        return value == null ? 0.0 : value.doubleValue();
    }

    public synchronized void setDoubleCounter(String key, double value) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)key), (String)"\u8bbe\u7f6ecounter\u7684key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.counter.put(key, value);
    }

    public synchronized void increaseCounter(String key, long deltaValue) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)key), (String)"\u589e\u52a0counter\u7684key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        long value = this.getLongCounter(key);
        this.counter.put(key, value + deltaValue);
    }

    public Communication clone() {
        Serializable value;
        String key;
        Communication communication = new Communication();
        if (this.counter != null) {
            for (Map.Entry<String, Number> entry : this.counter.entrySet()) {
                key = entry.getKey();
                value = entry.getValue();
                if (value instanceof Long) {
                    communication.setLongCounter(key, (Long)value);
                    continue;
                }
                if (!(value instanceof Double)) continue;
                communication.setDoubleCounter(key, (Double)value);
            }
        }
        communication.setState(this.state, true);
        communication.setThrowable(this.throwable, true);
        communication.setTimestamp(this.timestamp);
        if (this.message != null) {
            for (final Map.Entry<String, Object> entry : this.message.entrySet()) {
                key = entry.getKey();
                value = new ArrayList(){
                    {
                        this.addAll((Collection)entry.getValue());
                    }
                };
                communication.getMessage().put(key, (List<String>)((Object)value));
            }
        }
        return communication;
    }

    public synchronized Communication mergeFrom(Communication otherComm) {
        String key;
        if (otherComm == null) {
            return this;
        }
        for (Map.Entry<String, Number> entry : otherComm.getCounter().entrySet()) {
            key = entry.getKey();
            Number otherValue = entry.getValue();
            if (otherValue == null) continue;
            Number value = this.counter.get(key);
            value = value == null ? (Number)otherValue : (Number)(value instanceof Long && otherValue instanceof Long ? (Number)(value.longValue() + otherValue.longValue()) : (Number)(value.doubleValue() + value.doubleValue()));
            this.counter.put(key, value);
        }
        this.mergeStateFrom(otherComm);
        this.throwable = this.throwable == null ? otherComm.getThrowable() : this.throwable;
        for (Map.Entry<String, Object> entry : otherComm.getMessage().entrySet()) {
            key = entry.getKey();
            List<String> valueList = this.message.get(key);
            if (valueList == null) {
                valueList = new ArrayList<String>();
                this.message.put(key, valueList);
            }
            valueList.addAll((Collection)entry.getValue());
        }
        return this;
    }

    public synchronized State mergeStateFrom(Communication otherComm) {
        State retState = this.getState();
        if (otherComm == null) {
            return retState;
        }
        if (this.state == State.FAILED || otherComm.getState() == State.FAILED || this.state == State.KILLED || otherComm.getState() == State.KILLED) {
            retState = State.FAILED;
        } else if (this.state.isRunning() || otherComm.state.isRunning()) {
            retState = State.RUNNING;
        }
        this.setState(retState);
        return retState;
    }

    public synchronized boolean isFinished() {
        return this.state == State.SUCCEEDED || this.state == State.FAILED || this.state == State.KILLED;
    }
}

