/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.core.record;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import risesoft.data.transfer.core.column.Column;
import risesoft.data.transfer.core.context.JobContext;
import risesoft.data.transfer.core.plug.Plug;
import risesoft.data.transfer.core.record.AbstractRecordInHandle;
import risesoft.data.transfer.core.record.ColumnDisposeHandle;
import risesoft.data.transfer.core.record.Record;
import risesoft.data.transfer.core.record.RecordInHandle;

public class ColumnDisposeHandlePlug
extends AbstractRecordInHandle
implements Plug,
ColumnDisposeHandle,
RecordInHandle {
    private static final String REGISTER_FIELD_IN_CONTEXT_KEY = "REGISTER_FIELD_IN_CONTEXT_KEY";
    private Map<String, List<ColumnDisposeHandle>> cache;

    private ColumnDisposeHandlePlug(JobContext jobContext) {
        this.cache = ColumnDisposeHandlePlug.getCache(jobContext);
    }

    public static synchronized void registerListener(String field, ColumnDisposeHandle columnDisposeHandle, JobContext jobContext) {
        Map<String, List<ColumnDisposeHandle>> cache;
        List<ColumnDisposeHandle> handles;
        ColumnDisposeHandlePlug cd = jobContext.getHandles().getHandle(ColumnDisposeHandle.class, ColumnDisposeHandlePlug.class);
        if (cd == null) {
            jobContext.getHandles().add(new ColumnDisposeHandlePlug(jobContext));
        }
        if ((handles = (cache = ColumnDisposeHandlePlug.getCache(jobContext)).get(field)) == null) {
            handles = new ArrayList<ColumnDisposeHandle>();
            cache.put(field, handles);
        }
        handles.add(columnDisposeHandle);
    }

    private static Map<String, List<ColumnDisposeHandle>> getCache(JobContext jobContext) {
        HashMap valueObject = jobContext.getContext().get(REGISTER_FIELD_IN_CONTEXT_KEY);
        if (valueObject == null) {
            valueObject = new HashMap();
            jobContext.getContext().put(REGISTER_FIELD_IN_CONTEXT_KEY, valueObject);
        }
        return valueObject;
    }

    @Override
    public boolean register(JobContext jobContext) {
        return true;
    }

    @Override
    public Column dispose(Column column, Record record, int index) {
        return column;
    }

    @Override
    public void doIn(Record record) {
        for (int i = 0; i < record.getColumnNumber(); ++i) {
            Column column = record.getColumn(i);
            List<ColumnDisposeHandle> handles = this.cache.get(column.getName());
            if (handles == null) continue;
            for (ColumnDisposeHandle columnDisposeHandle : handles) {
                column = columnDisposeHandle.dispose(column, record, i);
            }
        }
    }
}

