/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.core.log;

import risesoft.data.transfer.core.log.LogHandleReference;
import risesoft.data.transfer.core.log.Logger;

public class HandledLogger
implements Logger {
    private String name;
    private LogHandleReference logHandleReference;

    public HandledLogger(LogHandleReference logHandleReference, String name) {
        this.name = name;
        this.logHandleReference = logHandleReference;
    }

    @Override
    public boolean isDebug() {
        return this.logHandleReference.isDebug();
    }

    @Override
    public boolean isInfo() {
        return this.logHandleReference.isInfo();
    }

    @Override
    public boolean isError() {
        return this.logHandleReference.isError();
    }

    @Override
    public void debug(Object source, String msg) {
        if (this.isDebug()) {
            String msgString = "DEBUG: " + this.name + ": " + msg;
            this.logHandleReference.getLogDebugHandle().handle(h -> h.debug(source, msgString));
        }
    }

    @Override
    public void info(Object source, String msg) {
        if (this.isInfo()) {
            String msgString = "INFO: " + this.name + ": " + msg;
            this.logHandleReference.getLogInfoHandle().handle(h -> h.info(source, msgString));
        }
    }

    @Override
    public void error(Object source, String msg) {
        if (this.isError()) {
            String msgString = "ERROR: " + this.name + ": " + msg;
            this.logHandleReference.getLogErrorHandle().handle(h -> h.error(source, msgString));
        }
    }
}

