/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.core.job;

import risesoft.data.transfer.core.Engine;
import risesoft.data.transfer.core.context.JobContext;
import risesoft.data.transfer.core.job.JobEngine;
import risesoft.data.transfer.core.statistics.Communication;
import risesoft.data.transfer.core.statistics.State;
import risesoft.data.transfer.core.util.CloseUtils;

public class JobRunningController {
    private boolean flag;
    private JobContext jobContext;
    private Communication communication;

    public JobRunningController(JobContext jobContext) {
        this.jobContext = jobContext;
        this.communication = jobContext.getCommunication();
        this.flag = false;
    }

    public synchronized void inEnd() {
        this.flag = true;
        this.end();
    }

    private synchronized void end() {
        long writerReceived;
        long readBytes = this.communication.getLongCounter("readSucceedBytes");
        if (readBytes == (writerReceived = this.communication.getLongCounter("writeReceivedBytes").longValue())) {
            CloseUtils.close(this.jobContext.getInExecutorTaskQueue());
            CloseUtils.close(this.jobContext.getOutExecutorTaskQueue());
            JobEngine.startJob(this.jobContext);
        }
    }

    public synchronized void onError(Throwable e) {
        this.communication.setThrowable(e);
        this.communication.setState(State.FAILED, true);
        Engine.onJobFlush(this.jobContext);
    }

    public synchronized boolean outEnd() {
        if (this.flag) {
            this.end();
        }
        return this.flag;
    }

    public synchronized boolean isEnd() {
        return this.flag;
    }
}

