/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.core.instruction;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import risesoft.data.transfer.core.config.ConfigLoad;
import risesoft.data.transfer.core.config.ConfigLoadManager;
import risesoft.data.transfer.core.context.JobContext;
import risesoft.data.transfer.core.exception.InstallException;
import risesoft.data.transfer.core.instruction.factory.InstructionFactory;
import risesoft.data.transfer.core.start.StartConfiguration;
import risesoft.data.transfer.core.util.ClassTools;
import risesoft.data.transfer.core.util.Configuration;

public class ParseInstructionFactory
implements StartConfiguration {
    private static final String rgex = "\\$(.*?)\\{(.*?)\\}";
    private static final Pattern p = Pattern.compile("\\$(.*?)\\{(.*?)\\}");
    private static final Map<String, InstructionFactory> INSTRUCTION_FACTORY_MAP = new HashMap<String, InstructionFactory>();

    public static InstructionFactory getInstance(String instruction) {
        return INSTRUCTION_FACTORY_MAP.get(instruction);
    }

    public static void registerFactory(InstructionFactory instructionFactory) {
        INSTRUCTION_FACTORY_MAP.put(instructionFactory.getName(), instructionFactory);
    }

    public static void registerOfPackage(String packageName) {
        try {
            List<InstructionFactory> instructionFactorys = ClassTools.getInstancesOfPack(packageName, InstructionFactory.class);
            for (InstructionFactory instructionFactory : instructionFactorys) {
                ParseInstructionFactory.registerFactory(instructionFactory);
            }
        }
        catch (Exception e) {
            throw new InstallException("\u4ece\u5305" + packageName + "\u4e2d\u6ce8\u518c\u6307\u4ee4\u5de5\u5382\u5931\u8d25!" + e.getMessage());
        }
    }

    static {
        ConfigLoadManager.addLoad(new ConfigLoad(){

            @Override
            public Configuration laod(Configuration config, JobContext jobContext) {
                String jsonConfig = config.toJSON();
                Matcher matcher = p.matcher(jsonConfig);
                HashMap<String, Byte> setMap = new HashMap<String, Byte>();
                while (matcher.find()) {
                    if (setMap.containsKey(matcher.group(0))) continue;
                    setMap.put(matcher.group(0), (byte)-128);
                    InstructionFactory instructionFactory = INSTRUCTION_FACTORY_MAP.get(matcher.group(1));
                    if (instructionFactory == null) continue;
                    jsonConfig = jsonConfig.replace(matcher.group(0), instructionFactory.getInstance(matcher.group(2).split("#"), jsonConfig).executor(jsonConfig, jobContext));
                }
                return setMap.size() == 0 ? config : Configuration.from(jsonConfig);
            }
        });
    }
}

