/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.core.handle;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import risesoft.data.transfer.core.handle.DoHandle;
import risesoft.data.transfer.core.handle.EmptyHandleContext;
import risesoft.data.transfer.core.handle.Handle;
import risesoft.data.transfer.core.handle.HandleContext;
import risesoft.data.transfer.core.util.ClassTools;

public class HandleManager {
    private Map<Class<?>, HandleContext<? extends Handle>> handles = new HashMap();

    public void addIfAbsent(Handle handle) {
        Set<Class<?>> classes = ClassTools.getInterfaceClass(handle.getClass());
        for (Class<?> class1 : classes) {
            if (!Handle.class.isAssignableFrom(class1)) continue;
            HandleContext<?> handleContext = this.getAndCreateContext(class1);
        }
    }

    public void add(Handle handle) {
        Set<Class<?>> classes = ClassTools.getInterfaceClass(handle.getClass());
        for (Class<?> class1 : classes) {
            if (!Handle.class.isAssignableFrom(class1)) continue;
            this.createContextAndAdd(class1, handle);
        }
    }

    private void createContextAndAdd(Class<?> class1, Handle handle) {
        HandleContext<Handle> context = this.handles.get(class1);
        if (context == null) {
            context = new HandleContext();
            this.handles.put(class1, context);
        }
        context.add(handle);
    }

    private HandleContext<?> getAndCreateContext(Class<?> class1) {
        HandleContext<Handle> context = this.handles.get(class1);
        if (context == null) {
            context = new HandleContext();
            this.handles.put(class1, context);
        }
        return context;
    }

    public <T> void doHandle(Class<T> handleType, DoHandle<T> doHandle) {
        HandleContext<? extends Handle> handleContext = this.handles.get(handleType);
        if (handleContext != null) {
            handleContext.handle(doHandle);
        }
    }

    public <T> HandleContext<T> getContext(Class<T> handleType) {
        HandleContext<? extends Handle> handleContext = this.handles.get(handleType);
        if (handleContext != null) {
            return this.handles.get(handleType);
        }
        return EmptyHandleContext.EMPTY;
    }

    public boolean hasHandle(Class<?> class1) {
        return this.handles.containsKey(class1);
    }

    public void removePlug(Class<?> classType, Handle handle) {
        HandleContext<? extends Handle> handleContext = this.handles.get(classType);
        if (handleContext != null) {
            this.handles.remove(handle);
        }
    }

    public <T> T getHandle(Class<?> handleType, Class<T> type) {
        HandleContext<? extends Handle> handleContext = this.handles.get(handleType);
        if (handleContext != null) {
            return handleContext.getHandle(type);
        }
        return null;
    }
}

