/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.core.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import risesoft.data.transfer.core.exception.ErrorCode;
import risesoft.data.transfer.core.exception.TransferException;
import risesoft.data.transfer.core.factory.DefaultCreateInstanceFactory;
import risesoft.data.transfer.core.factory.InstanceFactory;
import risesoft.data.transfer.core.util.Configuration;
import risesoft.data.transfer.core.util.ValueUtils;

public class FactoryManager {
    public static final String NAME = "name";
    public static final String FACTORY = "factory";
    private static InstanceFactory DEFAULT;
    private static Map<String, String> NAME_MAPPING;
    private static ErrorCode NOINSTANCE;
    private static final Map<String, InstanceFactory> INS_MAP;

    public static void setDefault(InstanceFactory instanceFactory) {
        DEFAULT = instanceFactory;
    }

    public static void initFactory(String name, InstanceFactory instanceFactory) {
        INS_MAP.put(name, instanceFactory);
    }

    public static void putNameMapping(String key, String value) {
        NAME_MAPPING.put(key, value);
    }

    public static String getName(String name) {
        String nameMapping = NAME_MAPPING.get(name);
        return nameMapping == null ? name : nameMapping;
    }

    public static InstanceFactory getFactory(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return DEFAULT;
        }
        InstanceFactory instanceFactory = INS_MAP.get(FactoryManager.getName(name));
        if (instanceFactory == null) {
            TransferException.as(NOINSTANCE, "\u672a\u627e\u5230\u540d\u5b57\u4e3a:" + name + "\u7684\u5de5\u5382\u5b9e\u4f8b");
        }
        return instanceFactory;
    }

    public static <T> List<T> getInstancesOfConfiguration(Configuration configuration, String key, Class<T> retClass, Map<Class<?>, Object> instanceMap) {
        List<Configuration> configurations = configuration.getListConfiguration(key);
        if (configurations != null) {
            ArrayList<T> retS = new ArrayList<T>();
            Object tmp = instanceMap.get(Configuration.class);
            for (int i = 0; i < configurations.size(); ++i) {
                Configuration tmpConfiguration = configurations.get(i);
                instanceMap.put(Configuration.class, tmpConfiguration);
                retS.add(FactoryManager.getInstanceOfConfiguration(tmpConfiguration, retClass, instanceMap));
            }
            instanceMap.put(Configuration.class, tmp);
            return retS;
        }
        return Collections.EMPTY_LIST;
    }

    public static <T> T getInstanceOfConfiguration(Configuration configuration, Class<T> retClass, Map<Class<?>, Object> instanceMap) {
        String name = FactoryManager.getName(ValueUtils.getRequired(configuration.getString(NAME), "\u63d2\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!"));
        String factory = FactoryManager.getName(configuration.getString(FACTORY));
        try {
            Object tmp = instanceMap.get(Configuration.class);
            instanceMap.put(Configuration.class, configuration.getConfigurationNotNull("args"));
            T resT = FactoryManager.getFactory(factory).getInstance(name, retClass, instanceMap);
            instanceMap.put(retClass.getClass(), resT);
            instanceMap.put(Configuration.class, tmp);
            return resT;
        }
        catch (TransferException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw TransferException.as(new ErrorCode(){

                @Override
                public String getDescription() {
                    return "\u672a\u9009\u62e9\u5408\u9002\u7684\u7c7b\u65e0\u6cd5\u521b\u5efa";
                }

                @Override
                public String getCode() {
                    return null;
                }
            }, "\u5728\u521b\u5efa\u5b9e\u4f8b\u65f6\u62a5\u9519:" + e.getMessage() + ",\u5b9e\u4f8b\u540d:" + name);
        }
    }

    static {
        NAME_MAPPING = new HashMap<String, String>();
        NOINSTANCE = new ErrorCode(){

            @Override
            public String getDescription() {
                return "\u672a\u627e\u5230\u5de5\u5382\u68c0\u67e5\u914d\u7f6e";
            }

            @Override
            public String getCode() {
                return "no factory";
            }
        };
        FactoryManager.setDefault(new DefaultCreateInstanceFactory());
        INS_MAP = new HashMap<String, InstanceFactory>();
    }
}

