/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.core.factory;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import risesoft.data.transfer.core.exception.CommonErrorCode;
import risesoft.data.transfer.core.exception.TransferException;
import risesoft.data.transfer.core.factory.annotations.ConfigBean;
import risesoft.data.transfer.core.factory.annotations.ConfigField;
import risesoft.data.transfer.core.factory.annotations.ConfigParameter;
import risesoft.data.transfer.core.util.Configuration;
import risesoft.data.transfer.core.util.FieldUtils;
import risesoft.data.transfer.core.util.strings.ValueCastHandleFactory;

public class BeanFactory {
    private static final Map<Class<?>, ConfigCache> CACHE = new HashMap();

    public static <T> T getInstance(Class<T> instanceClass, Configuration configuration) {
        ConfigCache configCache = BeanFactory.getCache(instanceClass);
        if (configCache != null) {
            try {
                T instanceObject = instanceClass.newInstance();
                for (ConfigFieldCache fieldCache : configCache.fields) {
                    String strValue;
                    Object value = configuration.get(fieldCache.configField.path().equals("") ? fieldCache.field.getName() : fieldCache.configField.path(), fieldCache.field.getType());
                    if (value == null) {
                        if (fieldCache.configField.value() != "") {
                            value = ValueCastHandleFactory.castValue(fieldCache.configField.value(), fieldCache.field.getType());
                        } else if (fieldCache.configField.required()) {
                            throw new RuntimeException("\u7f3a\u5931\u5fc5\u8981\u7684\u914d\u7f6e:" + fieldCache.configField.description());
                        }
                    }
                    if (value == null) continue;
                    if (fieldCache.configField.options().length > 0 && !fieldCache.options.contains(strValue = value.toString())) {
                        throw new RuntimeException("\u975e\u6cd5\u53c2\u6570:" + strValue + " " + fieldCache.configField.description() + " \u53ef\u9009\u503c\u4e3a:" + fieldCache.options);
                    }
                    fieldCache.field.set(instanceObject, value);
                }
                return instanceClass.cast(instanceObject);
            }
            catch (Exception e) {
                throw TransferException.as(CommonErrorCode.CONFIG_ERROR, "\u914d\u7f6e\u88c5\u914d\u5931\u8d25:" + e.getMessage(), e);
            }
        }
        return null;
    }

    public static Object getParameterValue(Configuration configuration, ConfigParameter configField, String name, Class<?> type) {
        Object value = configuration.get(configField.path().equals("") ? name : configField.path(), type);
        if (value == null) {
            if (configField.value() != "") {
                value = ValueCastHandleFactory.castValue(configField.value(), type);
            } else if (configField.required()) {
                throw new RuntimeException("\u7f3a\u5931\u5fc5\u8981\u7684\u914d\u7f6e:" + configField.description());
            }
        }
        if (value != null && configField.options().length > 0) {
            String strValue = value.toString();
            boolean flag = false;
            for (String optionValue : configField.options()) {
                if (!optionValue.equals(strValue)) continue;
                flag = true;
                break;
            }
            if (!flag) {
                throw new RuntimeException("\u975e\u6cd5\u53c2\u6570:" + strValue + " " + configField.description() + " \u53ef\u9009\u503c\u4e3a:" + configField.options());
            }
        }
        return value;
    }

    private static ConfigCache getCache(Class<?> instanceClass) {
        ConfigCache configCache = CACHE.get(instanceClass);
        if (configCache == null && instanceClass.getAnnotation(ConfigBean.class) != null) {
            configCache = new ConfigCache();
            configCache.fields = new ArrayList<ConfigFieldCache>();
            List<Field> fields = FieldUtils.getFields(instanceClass);
            for (Field field : fields) {
                ConfigField configField = field.getAnnotation(ConfigField.class);
                if (configField == null) continue;
                field.setAccessible(true);
                configCache.fields.add(new ConfigFieldCache(configField, field));
            }
        }
        return configCache;
    }

    static class ConfigFieldCache {
        private ConfigField configField;
        private Field field;
        private HashSet<String> options;

        public ConfigFieldCache(ConfigField configField, Field field) {
            this.configField = configField;
            this.field = field;
            if (configField.options().length > 0) {
                this.options = new HashSet();
                this.options.addAll(Arrays.asList(configField.options()));
            }
        }
    }

    static class ConfigCache {
        private List<ConfigFieldCache> fields;

        ConfigCache() {
        }
    }
}

