/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.core.executor.out;

import java.util.List;
import risesoft.data.transfer.core.executor.Executor;
import risesoft.data.transfer.core.handle.DirtyRecordHandle;
import risesoft.data.transfer.core.handle.HandleManager;
import risesoft.data.transfer.core.record.Ack;
import risesoft.data.transfer.core.record.Record;
import risesoft.data.transfer.core.statistics.Communication;
import risesoft.data.transfer.core.statistics.CommunicationTool;
import risesoft.data.transfer.core.stream.out.DataOutputStream;
import risesoft.data.transfer.core.util.CloseUtils;

public class OutChannelExecutor
implements Executor,
Ack {
    private DataOutputStream dataOutputStream;
    private Communication communication;
    private HandleManager handleManager;

    public OutChannelExecutor(DataOutputStream dataOutputStream, Communication communication, HandleManager handleManager) {
        this.dataOutputStream = dataOutputStream;
        this.communication = communication;
        this.handleManager = handleManager;
    }

    @Override
    public void run(Object records) {
        this.dataOutputStream.writer((List)records, (Ack)this);
    }

    @Override
    public void close() {
        CloseUtils.close(this.dataOutputStream);
    }

    @Override
    public void confirm(Record record) {
        this.communication.increaseCounter("writeReceivedBytes", record.getByteSize());
        this.communication.increaseCounter("writeReceivedRecords", 1L);
    }

    @Override
    public void confirm(List<Record> record) {
        this.communication.increaseCounter("writeReceivedRecords", record.size());
        this.communication.increaseCounter("writeReceivedBytes", CommunicationTool.getRecordSize(record));
    }

    @Override
    public void cancel(Record record, Throwable e, String errorMag) {
        this.confirm(record);
        this.communication.increaseCounter("writeFailedRecords", 1L);
        this.communication.increaseCounter("writeFailedBytes", record.getByteSize());
        this.handleManager.doHandle(DirtyRecordHandle.class, handle -> handle.collectDirtyRecord(record, e, errorMag));
    }
}

