/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.core.executor.in;

import risesoft.data.transfer.core.channel.HandleInChannel;
import risesoft.data.transfer.core.channel.InChannel;
import risesoft.data.transfer.core.context.JobContext;
import risesoft.data.transfer.core.executor.Executor;
import risesoft.data.transfer.core.executor.ExecutorFacotry;
import risesoft.data.transfer.core.executor.in.InChannelExecutor;
import risesoft.data.transfer.core.record.RecordInHandle;
import risesoft.data.transfer.core.stream.in.DataInputStream;
import risesoft.data.transfer.core.stream.in.DataInputStreamFactory;
import risesoft.data.transfer.core.util.CloseUtils;

public class JobInputExecutorFactory
implements ExecutorFacotry {
    private JobContext JobContext;
    private DataInputStreamFactory dataInputStreamFactory;

    public JobInputExecutorFactory(JobContext jobContext, DataInputStreamFactory dataInputStream) {
        this.JobContext = jobContext;
        this.dataInputStreamFactory = dataInputStream;
    }

    @Override
    public Executor getInstance() {
        InChannel inChannel = this.JobContext.getInChannel();
        if (this.JobContext.getHandles().hasHandle(RecordInHandle.class)) {
            inChannel = new HandleInChannel(inChannel, this.JobContext.getHandles());
        }
        return new InChannelExecutor((DataInputStream)this.dataInputStreamFactory.getStream(), inChannel);
    }

    @Override
    public void close() {
        CloseUtils.close(this.dataInputStreamFactory);
        CloseUtils.close(this.JobContext.getCoreExchange());
    }
}

