/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.core.exchange;

import java.util.List;
import risesoft.data.transfer.core.channel.OutChannel;
import risesoft.data.transfer.core.exchange.Exchange;
import risesoft.data.transfer.core.record.Record;
import risesoft.data.transfer.core.statistics.Communication;
import risesoft.data.transfer.core.statistics.CommunicationTool;

public class CoreExchange
implements Exchange {
    private Exchange exchange;
    private Communication communication;

    public CoreExchange(Exchange exchange, Communication communication) {
        this.exchange = exchange;
        this.communication = communication;
    }

    @Override
    public synchronized void writer(Record record) {
        this.communication.increaseCounter("readSucceedBytes", record.getByteSize());
        this.communication.increaseCounter("readSucceedRecords", 1L);
        this.exchange.writer(record);
    }

    @Override
    public synchronized void writer(List<Record> record) {
        this.communication.increaseCounter("readSucceedBytes", CommunicationTool.getRecordSize(record));
        this.communication.increaseCounter("readSucceedRecords", record.size());
        this.exchange.writer(record);
    }

    @Override
    public synchronized void flush() {
        this.exchange.flush();
    }

    @Override
    public void close() throws Exception {
        this.exchange.close();
    }

    @Override
    public void setOutChannel(OutChannel channel) {
        this.exchange.setOutChannel(channel);
    }

    @Override
    public OutChannel getOutChannel() {
        return this.exchange.getOutChannel();
    }

    @Override
    public void shutdown() {
        this.exchange.shutdown();
    }
}

