/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.core.context;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import risesoft.data.transfer.core.channel.InChannel;
import risesoft.data.transfer.core.context.StreamContext;
import risesoft.data.transfer.core.exchange.Exchange;
import risesoft.data.transfer.core.executor.ExecutorTaskQueue;
import risesoft.data.transfer.core.factory.FactoryManager;
import risesoft.data.transfer.core.handle.DoHandle;
import risesoft.data.transfer.core.handle.HandleManager;
import risesoft.data.transfer.core.job.Job;
import risesoft.data.transfer.core.listener.JobListener;
import risesoft.data.transfer.core.log.Logger;
import risesoft.data.transfer.core.log.LoggerFactory;
import risesoft.data.transfer.core.statistics.Communication;
import risesoft.data.transfer.core.util.Configuration;

public class JobContext {
    private Communication communication;
    private String jobId;
    private HandleManager handles;
    private StreamContext streamContext;
    private Map<Class<?>, Object> instanceMap;
    private Exchange coreExchange;
    private List<Job> jobs;
    private int concurrentJob = 0;
    private ExecutorTaskQueue inExecutorTaskQueue;
    private Configuration inChannelConfiguration;
    private ExecutorTaskQueue outExecutorTaskQueue;
    private JobListener jobListener;
    private boolean isEnd;
    private LoggerFactory loggerFactory;
    private Logger logger;
    private String name;
    private Map<String, Object> contextMap;

    public JobContext(Communication communication, String jobId, HandleManager handles, JobListener jobListener) {
        this.communication = communication;
        this.jobId = jobId;
        this.handles = handles;
        this.streamContext = new StreamContext();
        this.instanceMap = new HashMap();
        this.contextMap = new HashMap<String, Object>();
        this.jobListener = jobListener;
        this.putInstance(this);
        this.putInstance(handles);
        this.putInstance(communication);
    }

    public Map<String, Object> getContext() {
        return this.contextMap;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = loggerFactory.getLogger(JobContext.class);
        this.instanceMap.put(LoggerFactory.class, loggerFactory);
        this.instanceMap.put(Logger.class, this.logger);
    }

    public synchronized boolean isEnd() {
        return this.isEnd;
    }

    public synchronized void setEnd(boolean isEnd) {
        this.isEnd = isEnd;
    }

    public JobListener getJobListener() {
        return this.jobListener;
    }

    public void setJobListener(JobListener jobListener) {
        this.jobListener = jobListener;
    }

    public JobContext setCoreExchange(Exchange exchange) {
        this.coreExchange = exchange;
        return this;
    }

    public Exchange getCoreExchange() {
        return this.coreExchange;
    }

    public void putInstance(Class<?> key, Object instance) {
        this.instanceMap.put(key, instance);
    }

    public Map<Class<?>, Object> getInstanceMap() {
        return this.instanceMap;
    }

    public void putInstance(Object instance) {
        this.instanceMap.put(instance.getClass(), instance);
    }

    public <T> T getInstance(Class<T> key) {
        return key.cast(this.instanceMap.get(key));
    }

    public StreamContext getStreamContext() {
        return this.streamContext;
    }

    public Communication getCommunication() {
        return this.communication;
    }

    public void setCommunication(Communication communication) {
        this.communication = communication;
    }

    public String getJobId() {
        return this.jobId;
    }

    public HandleManager getHandles() {
        return this.handles;
    }

    public void setJobs(List<Job> jobs) {
        this.jobs = jobs;
    }

    public Job nextJob() {
        return this.jobs.get(this.concurrentJob++);
    }

    public boolean hasJob() {
        return this.jobs.size() > this.concurrentJob;
    }

    public Job getConcurrentJob() {
        return this.jobs.get(this.concurrentJob);
    }

    public ExecutorTaskQueue getInExecutorTaskQueue() {
        return this.inExecutorTaskQueue;
    }

    public JobContext setInExecutorTaskQueue(ExecutorTaskQueue inExecutorTaskQueue) {
        this.inExecutorTaskQueue = inExecutorTaskQueue;
        return this;
    }

    public ExecutorTaskQueue getOutExecutorTaskQueue() {
        return this.outExecutorTaskQueue;
    }

    public JobContext setOutExecutorTaskQueue(ExecutorTaskQueue outExecutorTaskQueue) {
        this.outExecutorTaskQueue = outExecutorTaskQueue;
        return this;
    }

    public <T> void doHandle(Class<T> handleType, DoHandle<T> doHandle) {
        this.handles.doHandle(handleType, doHandle);
    }

    public JobContext setInChannelConfiguration(Configuration inChannelConfiguration) {
        this.inChannelConfiguration = inChannelConfiguration;
        return this;
    }

    public InChannel getInChannel() {
        InChannel inChannel = FactoryManager.getInstanceOfConfiguration(this.inChannelConfiguration, InChannel.class, this.instanceMap);
        inChannel.setOutPutStream(this.coreExchange);
        return inChannel;
    }
}

