/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.core.column.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import risesoft.data.transfer.core.column.Column;
import risesoft.data.transfer.core.column.impl.ColumnCast;
import risesoft.data.transfer.core.column.impl.OverFlowUtil;
import risesoft.data.transfer.core.exception.CommonErrorCode;
import risesoft.data.transfer.core.exception.ErrorCode;
import risesoft.data.transfer.core.exception.TransferException;

public class StringColumn
extends Column {
    public StringColumn() {
        this(null, null);
    }

    public StringColumn(String rawData, String name) {
        super(rawData, Column.Type.STRING, null == rawData ? 0 : rawData.length(), name);
    }

    @Override
    public String asString() {
        if (null == this.getRawData()) {
            return null;
        }
        return (String)this.getRawData();
    }

    private void validateDoubleSpecific(String data) {
        if ("NaN".equals(data) || "Infinity".equals(data) || "-Infinity".equals(data)) {
            throw TransferException.as((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, String.format("String[\"%s\"]\u5c5e\u4e8eDouble\u7279\u6b8a\u7c7b\u578b\uff0c\u4e0d\u80fd\u8f6c\u4e3a\u5176\u4ed6\u7c7b\u578b .", data));
        }
    }

    @Override
    public BigInteger asBigInteger() {
        if (null == this.getRawData()) {
            return null;
        }
        this.validateDoubleSpecific((String)this.getRawData());
        try {
            return this.asBigDecimal().toBigInteger();
        }
        catch (Exception e) {
            throw TransferException.as((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, String.format("String[\"%s\"]\u4e0d\u80fd\u8f6c\u4e3aBigInteger .", this.asString()));
        }
    }

    @Override
    public Long asLong() {
        if (null == this.getRawData()) {
            return null;
        }
        this.validateDoubleSpecific((String)this.getRawData());
        try {
            BigInteger integer = this.asBigInteger();
            OverFlowUtil.validateLongNotOverFlow(integer);
            return integer.longValue();
        }
        catch (Exception e) {
            throw TransferException.as((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, String.format("String[\"%s\"]\u4e0d\u80fd\u8f6c\u4e3aLong .", this.asString()));
        }
    }

    @Override
    public BigDecimal asBigDecimal() {
        if (null == this.getRawData()) {
            return null;
        }
        this.validateDoubleSpecific((String)this.getRawData());
        try {
            return new BigDecimal(this.asString());
        }
        catch (Exception e) {
            throw TransferException.as((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, String.format("String [\"%s\"] \u4e0d\u80fd\u8f6c\u4e3aBigDecimal .", this.toString()));
        }
    }

    @Override
    public Double asDouble() {
        if (null == this.getRawData()) {
            return null;
        }
        String data = (String)this.getRawData();
        if ("NaN".equals(data)) {
            return Double.NaN;
        }
        if ("Infinity".equals(data)) {
            return Double.POSITIVE_INFINITY;
        }
        if ("-Infinity".equals(data)) {
            return Double.NEGATIVE_INFINITY;
        }
        BigDecimal decimal = this.asBigDecimal();
        OverFlowUtil.validateDoubleNotOverFlow(decimal);
        return decimal.doubleValue();
    }

    @Override
    public Boolean asBoolean() {
        if (null == this.getRawData()) {
            return null;
        }
        if ("true".equalsIgnoreCase(this.asString())) {
            return true;
        }
        if ("false".equalsIgnoreCase(this.asString())) {
            return false;
        }
        throw TransferException.as((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, String.format("String[\"%s\"]\u4e0d\u80fd\u8f6c\u4e3aBool .", this.asString()));
    }

    @Override
    public Date asDate() {
        try {
            return ColumnCast.string2Date(this);
        }
        catch (Exception e) {
            throw TransferException.as((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, String.format("String[\"%s\"]\u4e0d\u80fd\u8f6c\u4e3aDate .", this.asString()));
        }
    }

    @Override
    public byte[] asBytes() {
        try {
            return ColumnCast.string2Bytes(this);
        }
        catch (Exception e) {
            throw TransferException.as((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, String.format("String[\"%s\"]\u4e0d\u80fd\u8f6c\u4e3aBytes .", this.asString()));
        }
    }
}

