/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.core.column.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import risesoft.data.transfer.core.exception.CommonErrorCode;
import risesoft.data.transfer.core.exception.ErrorCode;
import risesoft.data.transfer.core.exception.TransferException;

public final class OverFlowUtil {
    public static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    public static final BigInteger MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
    public static final BigDecimal MIN_DOUBLE_POSITIVE = new BigDecimal(String.valueOf(Double.MIN_VALUE));
    public static final BigDecimal MAX_DOUBLE_POSITIVE = new BigDecimal(String.valueOf(Double.MAX_VALUE));

    public static boolean isLongOverflow(BigInteger integer) {
        return integer.compareTo(MAX_LONG) > 0 || integer.compareTo(MIN_LONG) < 0;
    }

    public static void validateLongNotOverFlow(BigInteger integer) {
        boolean isOverFlow = OverFlowUtil.isLongOverflow(integer);
        if (isOverFlow) {
            throw TransferException.as((ErrorCode)CommonErrorCode.CONVERT_OVER_FLOW, String.format("[%s] \u8f6c\u4e3aLong\u7c7b\u578b\u51fa\u73b0\u6ea2\u51fa .", integer.toString()));
        }
    }

    public static boolean isDoubleOverFlow(BigDecimal decimal) {
        boolean isPositive;
        if (decimal.signum() == 0) {
            return false;
        }
        BigDecimal newDecimal = decimal;
        boolean bl = isPositive = decimal.signum() == 1;
        if (!isPositive) {
            newDecimal = decimal.negate();
        }
        return newDecimal.compareTo(MIN_DOUBLE_POSITIVE) < 0 || newDecimal.compareTo(MAX_DOUBLE_POSITIVE) > 0;
    }

    public static void validateDoubleNotOverFlow(BigDecimal decimal) {
        boolean isOverFlow = OverFlowUtil.isDoubleOverFlow(decimal);
        if (isOverFlow) {
            throw TransferException.as((ErrorCode)CommonErrorCode.CONVERT_OVER_FLOW, String.format("[%s]\u8f6c\u4e3aDouble\u7c7b\u578b\u51fa\u73b0\u6ea2\u51fa .", decimal.toPlainString()));
        }
    }
}

