/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.core.column.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.apache.commons.lang3.math.NumberUtils;
import risesoft.data.transfer.core.column.Column;
import risesoft.data.transfer.core.column.impl.OverFlowUtil;
import risesoft.data.transfer.core.exception.CommonErrorCode;
import risesoft.data.transfer.core.exception.ErrorCode;
import risesoft.data.transfer.core.exception.TransferException;

public class LongColumn
extends Column {
    public LongColumn(String data, String name) {
        super(null, Column.Type.LONG, 0L, name);
        if (null == data) {
            return;
        }
        try {
            BigInteger rawData = NumberUtils.createBigDecimal((String)data).toBigInteger();
            super.setRawData(rawData);
            super.setByteSize(data.length());
        }
        catch (Exception e) {
            throw TransferException.as((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, String.format("String[%s]\u4e0d\u80fd\u8f6c\u4e3aLong .", data));
        }
    }

    public LongColumn(Long data, String name) {
        this(null == data ? (BigInteger)null : BigInteger.valueOf(data), name);
    }

    public LongColumn(Integer data, String name) {
        this(null == data ? (BigInteger)null : BigInteger.valueOf(data.intValue()), name);
    }

    public LongColumn(BigInteger data, String name) {
        this(data, null == data ? 0 : 8, name);
    }

    private LongColumn(BigInteger data, int byteSize, String name) {
        super(data, Column.Type.LONG, byteSize, name);
    }

    public LongColumn(String name) {
        this((BigInteger)null, name);
    }

    @Override
    public BigInteger asBigInteger() {
        if (null == this.getRawData()) {
            return null;
        }
        return (BigInteger)this.getRawData();
    }

    @Override
    public Long asLong() {
        BigInteger rawData = (BigInteger)this.getRawData();
        if (null == rawData) {
            return null;
        }
        OverFlowUtil.validateLongNotOverFlow(rawData);
        return rawData.longValue();
    }

    @Override
    public Double asDouble() {
        if (null == this.getRawData()) {
            return null;
        }
        BigDecimal decimal = this.asBigDecimal();
        OverFlowUtil.validateDoubleNotOverFlow(decimal);
        return decimal.doubleValue();
    }

    @Override
    public Boolean asBoolean() {
        if (null == this.getRawData()) {
            return null;
        }
        return this.asBigInteger().compareTo(BigInteger.ZERO) != 0;
    }

    @Override
    public BigDecimal asBigDecimal() {
        if (null == this.getRawData()) {
            return null;
        }
        return new BigDecimal(this.asBigInteger());
    }

    @Override
    public String asString() {
        if (null == this.getRawData()) {
            return null;
        }
        return ((BigInteger)this.getRawData()).toString();
    }

    @Override
    public Date asDate() {
        if (null == this.getRawData()) {
            return null;
        }
        return new Date(this.asLong());
    }

    @Override
    public byte[] asBytes() {
        throw TransferException.as((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, "Long\u7c7b\u578b\u4e0d\u80fd\u8f6c\u4e3aBytes .");
    }
}

