/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.core.column.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import risesoft.data.transfer.core.column.Column;
import risesoft.data.transfer.core.column.impl.ColumnCast;
import risesoft.data.transfer.core.exception.CommonErrorCode;
import risesoft.data.transfer.core.exception.ErrorCode;
import risesoft.data.transfer.core.exception.TransferException;

public class DateColumn
extends Column {
    private DateType subType = DateType.DATETIME;

    public DateColumn(String name) {
        this((Long)null, name);
    }

    public DateColumn(Long stamp, String name) {
        super(stamp, Column.Type.DATE, null == stamp ? 0 : 8, name);
    }

    public DateColumn(Date date, String name) {
        this(date == null ? null : Long.valueOf(date.getTime()), name);
    }

    public DateColumn(java.sql.Date date, String name) {
        this(date == null ? null : Long.valueOf(date.getTime()), name);
        this.setSubType(DateType.DATE);
    }

    public DateColumn(Time time, String name) {
        this(time == null ? null : Long.valueOf(time.getTime()), name);
        this.setSubType(DateType.TIME);
    }

    public DateColumn(Timestamp ts, String name) {
        this(ts == null ? null : Long.valueOf(ts.getTime()), name);
        this.setSubType(DateType.DATETIME);
    }

    @Override
    public Long asLong() {
        return (Long)this.getRawData();
    }

    @Override
    public String asString() {
        try {
            return ColumnCast.date2String(this);
        }
        catch (Exception e) {
            throw TransferException.as((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, String.format("Date[%s]\u7c7b\u578b\u4e0d\u80fd\u8f6c\u4e3aString .", this.toString()));
        }
    }

    @Override
    public Date asDate() {
        if (null == this.getRawData()) {
            return null;
        }
        return new Date((Long)this.getRawData());
    }

    @Override
    public byte[] asBytes() {
        throw TransferException.as((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, "Date\u7c7b\u578b\u4e0d\u80fd\u8f6c\u4e3aBytes .");
    }

    @Override
    public Boolean asBoolean() {
        throw TransferException.as((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, "Date\u7c7b\u578b\u4e0d\u80fd\u8f6c\u4e3aBoolean .");
    }

    @Override
    public Double asDouble() {
        throw TransferException.as((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, "Date\u7c7b\u578b\u4e0d\u80fd\u8f6c\u4e3aDouble .");
    }

    @Override
    public BigInteger asBigInteger() {
        throw TransferException.as((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, "Date\u7c7b\u578b\u4e0d\u80fd\u8f6c\u4e3aBigInteger .");
    }

    @Override
    public BigDecimal asBigDecimal() {
        throw TransferException.as((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, "Date\u7c7b\u578b\u4e0d\u80fd\u8f6c\u4e3aBigDecimal .");
    }

    public DateType getSubType() {
        return this.subType;
    }

    public void setSubType(DateType subType) {
        this.subType = subType;
    }

    public static enum DateType {
        DATE,
        TIME,
        DATETIME;

    }
}

