/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.core.column.impl;

import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.time.DateFormatUtils;
import risesoft.data.transfer.core.column.impl.DateColumn;
import risesoft.data.transfer.core.exception.CommonErrorCode;
import risesoft.data.transfer.core.exception.ErrorCode;
import risesoft.data.transfer.core.exception.TransferException;
import risesoft.data.transfer.core.util.Configuration;

class DateCast {
    static String datetimeFormat = "yyyy-MM-dd HH:mm:ss";
    static String dateFormat = "yyyy-MM-dd";
    static String timeFormat = "HH:mm:ss";
    static String timeZone = "GMT+8";
    static TimeZone timeZoner = TimeZone.getTimeZone(timeZone);

    DateCast() {
    }

    static void init(Configuration configuration) {
        datetimeFormat = configuration.getString("common.column.datetimeFormat", datetimeFormat);
        timeFormat = configuration.getString("common.column.timeFormat", timeFormat);
        dateFormat = configuration.getString("common.column.dateFormat", dateFormat);
        timeZone = configuration.getString("common.column.timeZone", timeZone);
        timeZoner = TimeZone.getTimeZone(timeZone);
    }

    static String asString(DateColumn column) {
        if (null == column.asDate()) {
            return null;
        }
        switch (column.getSubType()) {
            case DATE: {
                return DateFormatUtils.format((Date)column.asDate(), (String)dateFormat, (TimeZone)timeZoner);
            }
            case TIME: {
                return DateFormatUtils.format((Date)column.asDate(), (String)timeFormat, (TimeZone)timeZoner);
            }
            case DATETIME: {
                return DateFormatUtils.format((Date)column.asDate(), (String)datetimeFormat, (TimeZone)timeZoner);
            }
        }
        throw TransferException.as((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, "\u65f6\u95f4\u7c7b\u578b\u51fa\u73b0\u4e0d\u652f\u6301\u7c7b\u578b\uff0c\u76ee\u524d\u4ec5\u652f\u6301DATE/TIME/DATETIME\u3002\u8be5\u7c7b\u578b\u5c5e\u4e8e\u7f16\u7a0b\u9519\u8bef\uff0c\u8bf7\u53cd\u9988 .");
    }
}

