/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.core.column.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.apache.commons.lang3.ArrayUtils;
import risesoft.data.transfer.core.column.Column;
import risesoft.data.transfer.core.column.impl.ColumnCast;
import risesoft.data.transfer.core.exception.CommonErrorCode;
import risesoft.data.transfer.core.exception.ErrorCode;
import risesoft.data.transfer.core.exception.TransferException;

public class BytesColumn
extends Column {
    public BytesColumn(String name) {
        this(null, name);
    }

    public BytesColumn(byte[] bytes, String name) {
        super(ArrayUtils.clone((byte[])bytes), Column.Type.BYTES, null == bytes ? 0L : (long)bytes.length, name);
    }

    @Override
    public byte[] asBytes() {
        if (null == this.getRawData()) {
            return null;
        }
        return (byte[])this.getRawData();
    }

    @Override
    public String asString() {
        if (null == this.getRawData()) {
            return null;
        }
        try {
            return ColumnCast.bytes2String(this);
        }
        catch (Exception e) {
            throw TransferException.as((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, String.format("Bytes[%s]\u4e0d\u80fd\u8f6c\u4e3aString .", this.toString()));
        }
    }

    @Override
    public Long asLong() {
        throw TransferException.as((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, "Bytes\u7c7b\u578b\u4e0d\u80fd\u8f6c\u4e3aLong .");
    }

    @Override
    public BigDecimal asBigDecimal() {
        throw TransferException.as((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, "Bytes\u7c7b\u578b\u4e0d\u80fd\u8f6c\u4e3aBigDecimal .");
    }

    @Override
    public BigInteger asBigInteger() {
        throw TransferException.as((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, "Bytes\u7c7b\u578b\u4e0d\u80fd\u8f6c\u4e3aBigInteger .");
    }

    @Override
    public Double asDouble() {
        throw TransferException.as((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, "Bytes\u7c7b\u578b\u4e0d\u80fd\u8f6c\u4e3aLong .");
    }

    @Override
    public Date asDate() {
        throw TransferException.as((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, "Bytes\u7c7b\u578b\u4e0d\u80fd\u8f6c\u4e3aDate .");
    }

    @Override
    public Boolean asBoolean() {
        throw TransferException.as((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, "Bytes\u7c7b\u578b\u4e0d\u80fd\u8f6c\u4e3aBoolean .");
    }
}

