/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.core.channel;

import java.util.List;
import risesoft.data.transfer.core.channel.InChannel;
import risesoft.data.transfer.core.handle.HandleContext;
import risesoft.data.transfer.core.handle.HandleManager;
import risesoft.data.transfer.core.record.Record;
import risesoft.data.transfer.core.record.RecordInHandle;
import risesoft.data.transfer.core.stream.out.RecordOutuptStream;
import risesoft.data.transfer.core.util.CloseUtils;

public class HandleInChannel
implements InChannel {
    private InChannel inChannel;
    private HandleContext<RecordInHandle> recordHandleContext;

    public HandleInChannel(InChannel inChannel, HandleManager handleManager) {
        this.inChannel = inChannel;
        this.recordHandleContext = handleManager.getContext(RecordInHandle.class);
    }

    @Override
    public void setOutPutStream(RecordOutuptStream recordOutuptStream) {
        this.inChannel.setOutPutStream(recordOutuptStream);
    }

    @Override
    public void writer(Record record) {
        this.recordHandleContext.handle(handle -> handle.doIn(record));
        this.inChannel.writer(record);
    }

    @Override
    public void close() throws Exception {
        CloseUtils.close(this.inChannel);
    }

    @Override
    public void writer(List<Record> record) {
        this.recordHandleContext.handle(handle -> handle.doIn(record));
        this.inChannel.writer(record);
    }

    @Override
    public void flush() {
        this.inChannel.flush();
    }

    @Override
    public void collectDirtyRecord(Record record, Throwable t, String errorMessage) {
        this.inChannel.collectDirtyRecord(record, t, errorMessage);
    }
}

