/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.core.channel;

import risesoft.data.transfer.core.channel.InChannel;
import risesoft.data.transfer.core.context.JobContext;
import risesoft.data.transfer.core.handle.DirtyRecordHandle;
import risesoft.data.transfer.core.handle.HandleManager;
import risesoft.data.transfer.core.record.Record;
import risesoft.data.transfer.core.statistics.Communication;
import risesoft.data.transfer.core.stream.out.RecordOutuptStream;

public abstract class AbstractInChannel
implements InChannel {
    protected RecordOutuptStream recordOutuptStream;
    protected Communication communication;
    private HandleManager handleManager;

    public AbstractInChannel(JobContext jobContext) {
        this.communication = jobContext.getCommunication();
        this.handleManager = jobContext.getHandles();
    }

    @Override
    public void setOutPutStream(RecordOutuptStream recordOutuptStream) {
        this.recordOutuptStream = recordOutuptStream;
    }

    @Override
    public void close() throws Exception {
        this.recordOutuptStream.close();
    }

    @Override
    public void collectDirtyRecord(Record record, Throwable t, String errorMessage) {
        this.communication.increaseCounter("readFailedBytes", record.getByteSize());
        this.communication.increaseCounter("readFailedRecords", 1L);
        this.handleManager.doHandle(DirtyRecordHandle.class, handle -> handle.collectDirtyRecord(record, t, errorMessage));
    }
}

