/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.base.stream.in;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import risesoft.data.transfer.core.channel.InChannel;
import risesoft.data.transfer.core.column.Column;
import risesoft.data.transfer.core.column.impl.StringColumn;
import risesoft.data.transfer.core.data.Data;
import risesoft.data.transfer.core.data.ListConfigurationData;
import risesoft.data.transfer.core.record.DefaultRecord;
import risesoft.data.transfer.core.record.Record;
import risesoft.data.transfer.core.stream.in.DataInputStream;
import risesoft.data.transfer.core.stream.in.DataInputStreamFactory;
import risesoft.data.transfer.core.util.Configuration;
import risesoft.data.transfer.core.util.ValueUtils;

public class LocalReadInputStreamFactory
implements DataInputStreamFactory {
    private List<Configuration> datas;

    public LocalReadInputStreamFactory(Configuration configuration) {
        this.datas = (List)ValueUtils.getRequired((Object)configuration.getListConfiguration("datas"), (String)"\u6ca1\u6709\u6570\u636e");
    }

    public void init() {
    }

    public DataInputStream getStream() {
        return new DataInputStream(){

            public void close() throws Exception {
            }

            public void read(Data data, InChannel inChannel) {
                List lists = ((ListConfigurationData)data).getConfigurations();
                for (Configuration configuration : lists) {
                    Set keys = configuration.getKeys();
                    DefaultRecord defaultRecord = new DefaultRecord();
                    try {
                        for (String key : keys) {
                            defaultRecord.addColumn((Column)new StringColumn(configuration.get(key).toString(), key));
                        }
                        inChannel.writer((Record)defaultRecord);
                    }
                    catch (Exception e) {
                        inChannel.collectDirtyRecord((Record)defaultRecord, (Throwable)e, e.getMessage());
                    }
                }
                inChannel.flush();
            }
        };
    }

    public void close() throws Exception {
    }

    public List<Data> splitToData(int size) {
        ArrayList<Data> datas = new ArrayList<Data>();
        int i = 0;
        while (i * 2 < this.datas.size()) {
            datas.add((Data)new ListConfigurationData(this.datas.subList(i * 2, i * 2 + 2 > this.datas.size() ? this.datas.size() : i * 2 + 2)));
            ++i;
        }
        return datas;
    }
}

