/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.base.plug.log;

import java.util.Date;
import org.apache.commons.lang3.time.DateFormatUtils;
import risesoft.data.transfer.core.context.JobContext;
import risesoft.data.transfer.core.handle.Handle;
import risesoft.data.transfer.core.handle.HandleManager;
import risesoft.data.transfer.core.log.LogDebugHandle;
import risesoft.data.transfer.core.log.LogErrorHandle;
import risesoft.data.transfer.core.log.LogInfoHandle;
import risesoft.data.transfer.core.plug.Plug;
import risesoft.data.transfer.core.util.Configuration;

public class PrintLogPlug
implements Plug {
    private static final int DEBUG = 0;
    private static final int INFO = 1;
    private static final int ERROR = 2;

    public PrintLogPlug(Configuration configuration, HandleManager handleManager) {
        int level = configuration.getInt("level", 0);
        if (level <= 0) {
            handleManager.add((Handle)new LogDebugHandle(){

                public void debug(Object source, String debug) {
                    System.out.println(DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss ") + debug);
                }
            });
        }
        if (level <= 1) {
            handleManager.add((Handle)new LogInfoHandle(){

                public void info(Object source, String info) {
                    System.out.println(DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss ") + info);
                }
            });
        }
        if (level <= 2) {
            handleManager.add((Handle)new LogErrorHandle(){

                public void error(Object source, String msg) {
                    System.out.println(DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss ") + msg);
                }
            });
        }
    }

    public boolean register(JobContext jobContext) {
        return true;
    }
}

