/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.base.plug.data;

import risesoft.data.transfer.core.context.JobContext;
import risesoft.data.transfer.core.exception.CommonErrorCode;
import risesoft.data.transfer.core.exception.ErrorCode;
import risesoft.data.transfer.core.exception.TransferException;
import risesoft.data.transfer.core.handle.DirtyRecordHandle;
import risesoft.data.transfer.core.job.JobEndHandle;
import risesoft.data.transfer.core.plug.Plug;
import risesoft.data.transfer.core.record.Record;
import risesoft.data.transfer.core.statistics.Communication;
import risesoft.data.transfer.core.util.Configuration;

public class DirtyDataPlug
implements Plug,
DirtyRecordHandle,
JobEndHandle {
    private static final String DIRTY_DATA = "DIRTY_DATA";
    private Communication communication;
    private int record;
    private double percentage;
    private int size = 0;

    public DirtyDataPlug(Communication communication, Configuration configuration) {
        this.record = configuration.getInt("record", -1);
        this.percentage = configuration.getDouble("percentage", 0.0);
        this.communication = communication;
    }

    public boolean register(JobContext jobContext) {
        return true;
    }

    public void collectDirtyRecord(Record record, Throwable t, String errorMessage) {
        ++this.size;
        if (this.record != -1 && this.size > this.record) {
            throw TransferException.as((ErrorCode)CommonErrorCode.RUNTIME_ERROR, (String)("\u810f\u6570\u636e\u8d85\u51fa\u6761\u6570\u9650\u5236:" + record + "\u9519\u8bef\u4fe1\u606f:" + errorMessage));
        }
        if (this.communication.getMessage(DIRTY_DATA) == null || this.communication.getMessage(DIRTY_DATA).size() < 10) {
            this.communication.addMessage(DIRTY_DATA, "\u810f\u6570\u636e:" + record + "error:" + errorMessage + "\n");
        }
    }

    public void onJobEnd(JobContext jobContext) {
        long failedRecords = this.communication.getLongCounter("writeFailedRecords");
        long size = this.communication.getLongCounter("readSucceedRecords");
        if (this.percentage > 0.0 && (double)failedRecords / (double)size > this.percentage) {
            throw TransferException.as((ErrorCode)CommonErrorCode.RUNTIME_ERROR, (String)("\u810f\u6570\u636e\u8d85\u51fa\u6bd4\u4f8b\u9650\u5236!" + this.communication.getMessage(DIRTY_DATA)));
        }
    }
}

