/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.base.exchange;

import java.util.List;
import risesoft.data.transfer.core.exception.CommonErrorCode;
import risesoft.data.transfer.core.exception.ErrorCode;
import risesoft.data.transfer.core.exception.TransferException;
import risesoft.data.transfer.core.exchange.OutChannelExchange;
import risesoft.data.transfer.core.log.Logger;
import risesoft.data.transfer.core.record.Record;
import risesoft.data.transfer.core.util.Configuration;

public abstract class MoneyExchange
extends OutChannelExchange {
    protected int byteSize = 0;
    protected int recordSize = 0;
    protected long time;
    protected int speedByte;
    protected int speedRecord;
    protected double recordTime;
    protected double byteTime;
    protected int speed;
    protected Logger logger;

    public MoneyExchange(Configuration configuration, Logger logger) {
        this.speedByte = configuration.getInt("speed.byte", 0) * 1024;
        this.speedRecord = configuration.getInt("speed.record", 0);
        this.speed = configuration.getInt("speed.time", 1) * 1000;
        if (this.speedByte == 0 && this.speedRecord == 0) {
            throw TransferException.as((ErrorCode)CommonErrorCode.RUNTIME_ERROR, (String)"\u9650\u901f\u914d\u7f6e\u6761\u6570\u4e0e\u5927\u5c0f\u4e0d\u80fd\u540c\u65f6\u4e3a0,\u5982\u4e0d\u9700\u8981\u9650\u901f\u8bf7\u4f7f\u7528\u5176\u4ed6\u4ea4\u6362\u673a!");
        }
        this.recordTime = this.speedRecord <= 0 ? 0.0 : (double)this.speed / (double)this.speedRecord;
        this.byteTime = this.speedByte <= 0 ? 0.0 : (double)this.speed / (double)this.speedByte;
        this.logger = logger;
        this.time = System.currentTimeMillis();
    }

    public synchronized void writer(Record record) {
        if (this.isShutdown) {
            return;
        }
        if (this.logger.isDebug()) {
            this.logger.debug((Object)this, "writer " + record);
        }
        this.await(record.getByteSize(), 1);
        this.writerRecord(record);
    }

    protected abstract void writerRecord(Record var1);

    protected synchronized void await(int size, int record) {
        int sleepTime;
        if (this.speedByte > 0 && this.speedByte < size || this.speedRecord > 0 && this.speedRecord < record) {
            throw TransferException.as((ErrorCode)CommonErrorCode.RUNTIME_ERROR, (String)"\u914d\u7f6e\u7684\u9650\u901f\u65e0\u6cd5\u9650\u5236\u8bf7\u8c03\u6574\u9650\u901f\u5927\u5c0f!");
        }
        long concurrentTime = System.currentTimeMillis();
        int differTime = (int)((long)this.speed - (concurrentTime - this.time));
        if (differTime < 0) {
            this.time = concurrentTime;
            differTime = this.speed;
            this.recordSize = 0;
            this.byteSize = 0;
        }
        if ((sleepTime = (int)Math.max((double)(this.recordSize + record) * this.recordTime, (double)(this.byteSize + size) * this.byteTime) - this.speed) > 0) {
            try {
                if (this.logger.isDebug()) {
                    this.logger.debug((Object)this, "sleep:" + differTime);
                }
                Thread.sleep(differTime);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.time = System.currentTimeMillis() - (long)sleepTime;
            this.recordSize = (int)((double)sleepTime / this.recordTime);
            this.byteSize = (int)((double)sleepTime / this.byteTime);
        } else {
            this.byteSize += size;
            this.recordSize += record;
        }
    }

    public abstract void writer(List<Record> var1);

    public abstract void flush();

    public void shutdown() {
        this.isShutdown = true;
        this.logger.info((Object)this, "shutdown");
    }
}

