/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.base.exchange;

import java.util.ArrayList;
import java.util.List;
import risesoft.data.transfer.base.exchange.MoneyExchange;
import risesoft.data.transfer.core.log.LoggerFactory;
import risesoft.data.transfer.core.record.Record;
import risesoft.data.transfer.core.statistics.CommunicationTool;
import risesoft.data.transfer.core.util.Configuration;
import risesoft.data.transfer.core.util.StrUtil;

public class DCMoneyExchange
extends MoneyExchange {
    public DCMoneyExchange(Configuration configuration, LoggerFactory loggerFactory) {
        super(configuration, loggerFactory.getLogger(configuration.getString("name", "BufferRecordMoneyExchange")));
        this.logger.info((Object)this, "DC record created \n speedByte: " + StrUtil.stringify((long)this.speedByte) + " \n speedRecord: " + this.speedRecord + " \n time: " + this.speed / 1000 + "/s");
    }

    @Override
    public synchronized void writer(List<Record> record) {
        if (this.isShutdown) {
            return;
        }
        if (this.logger.isDebug()) {
            this.logger.debug((Object)this, "writer " + record.size());
        }
        this.await((int)CommunicationTool.getRecordSize(record), record.size());
        this.channel.writer(new ArrayList<Record>(record));
    }

    @Override
    public synchronized void flush() {
        if (this.isShutdown) {
            return;
        }
        if (this.logger.isDebug()) {
            this.logger.debug((Object)this, "flush ");
        }
        this.channel.flush();
    }

    @Override
    protected void writerRecord(Record record) {
        this.channel.writer(record);
    }
}

