/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.base.exchange;

import java.util.ArrayList;
import java.util.List;
import risesoft.data.transfer.core.exchange.OutChannelExchange;
import risesoft.data.transfer.core.log.Logger;
import risesoft.data.transfer.core.log.LoggerFactory;
import risesoft.data.transfer.core.record.Record;
import risesoft.data.transfer.core.util.Configuration;

public class DCExchange
extends OutChannelExchange {
    private Logger logger;
    private volatile boolean isShutdown = false;

    public DCExchange(Configuration configuration, LoggerFactory loggerFactory) {
        this.logger = loggerFactory.getLogger(configuration.getString("name", "DCExchange"));
    }

    public void writer(Record record) {
        if (this.isShutdown) {
            return;
        }
        if (this.logger.isDebug()) {
            this.logger.debug((Object)this, "writer: " + record);
        }
        this.channel.writer(record);
    }

    public void writer(List<Record> record) {
        if (this.isShutdown) {
            return;
        }
        if (this.logger.isDebug()) {
            this.logger.debug((Object)this, "writer: " + record.size());
        }
        this.channel.writer(new ArrayList<Record>(record));
    }

    public void shutdown() {
        this.isShutdown = true;
        this.logger.info((Object)this, "shutdown");
    }

    public void flush() {
        if (this.isShutdown) {
            return;
        }
        if (this.logger.isDebug()) {
            this.logger.debug((Object)this, "flush ");
        }
        this.channel.flush();
    }
}

