/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.base.exchange;

import java.util.ArrayList;
import java.util.List;
import risesoft.data.transfer.base.exchange.MoneyExchange;
import risesoft.data.transfer.core.log.LoggerFactory;
import risesoft.data.transfer.core.record.Record;
import risesoft.data.transfer.core.statistics.CommunicationTool;
import risesoft.data.transfer.core.util.Configuration;
import risesoft.data.transfer.core.util.StrUtil;

public class BufferRecordMoneyExchange
extends MoneyExchange {
    private int bufferRecord;
    private ArrayList<Record> records;

    public BufferRecordMoneyExchange(Configuration configuration, LoggerFactory loggerFactory) {
        super(configuration, loggerFactory.getLogger(configuration.getString("name", "BufferRecordMoneyExchange")));
        this.bufferRecord = configuration.getInt("bufferRecord", 1024);
        this.records = new ArrayList();
        this.logger.info((Object)this, "buffer record created buffer:" + this.bufferRecord + "\n speedByte: " + StrUtil.stringify((long)this.speedByte) + " \n speedRecord: " + this.speedRecord + " \n time: " + this.speed / 1000 + "/s");
    }

    private void ofFlush() {
        if (this.records.size() == this.bufferRecord) {
            this.flushBuffer();
        }
    }

    @Override
    public synchronized void writer(List<Record> record) {
        if (this.isShutdown) {
            return;
        }
        if (this.logger.isDebug()) {
            this.logger.debug((Object)this, "writer " + record.size());
        }
        int end = 0;
        int start = 0;
        while (end < record.size()) {
            if ((end += this.bufferRecord - this.records.size()) > record.size()) {
                end = record.size();
            }
            this.await((int)CommunicationTool.getRecordSize(record, (int)start, (int)end), end - start);
            this.records.addAll(new ArrayList<Record>(record.subList(start, end)));
            start = end;
            this.ofFlush();
        }
    }

    @Override
    public synchronized void flush() {
        if (this.isShutdown) {
            return;
        }
        this.flushBuffer();
    }

    private void flushBuffer() {
        if (this.logger.isDebug()) {
            this.logger.debug((Object)this, "flush " + this.records.size());
        }
        this.channel.writer(new ArrayList<Record>(this.records));
        this.channel.flush();
        this.records.clear();
    }

    @Override
    protected void writerRecord(Record record) {
        this.records.add(record);
        this.ofFlush();
    }
}

