/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.base.exchange;

import java.util.ArrayList;
import java.util.List;
import risesoft.data.transfer.core.exchange.OutChannelExchange;
import risesoft.data.transfer.core.log.Logger;
import risesoft.data.transfer.core.log.LoggerFactory;
import risesoft.data.transfer.core.record.Record;
import risesoft.data.transfer.core.util.Configuration;

public class BufferRecordExchange
extends OutChannelExchange {
    private int bufferRecord;
    private ArrayList<Record> records;
    private Logger logger;
    private volatile boolean isShutdown = false;

    public BufferRecordExchange(Configuration configuration, LoggerFactory loggerFactory) {
        this.bufferRecord = configuration.getInt("bufferRecord", 1024);
        this.records = new ArrayList(this.bufferRecord);
        this.logger = loggerFactory.getLogger(configuration.getString("name", "BufferRecordExchange"));
        this.logger.info((Object)this, "init");
    }

    public synchronized void writer(Record record) {
        if (this.isShutdown) {
            return;
        }
        if (this.logger.isDebug()) {
            this.logger.debug((Object)this, "writer: " + record);
        }
        this.records.add(record);
        if (this.records.size() == this.bufferRecord) {
            this.flush();
        }
    }

    public synchronized void writer(List<Record> record) {
        if (this.isShutdown) {
            return;
        }
        if (this.logger.isDebug()) {
            this.logger.debug((Object)this, "writer " + record.size());
        }
        int end = 0;
        int start = 0;
        while (end < record.size()) {
            if ((end += this.bufferRecord - this.records.size()) > record.size()) {
                end = record.size();
            }
            this.records.addAll(new ArrayList<Record>(record.subList(start, end)));
            start = end;
            this.flush();
        }
    }

    public synchronized void flush() {
        if (this.isShutdown) {
            return;
        }
        if (this.logger.isDebug()) {
            this.logger.debug((Object)this, "flush " + this.records.size());
        }
        this.channel.writer(new ArrayList<Record>(this.records));
        this.channel.flush();
        this.records.clear();
    }

    public void shutdown() {
        this.isShutdown = true;
        this.logger.info((Object)this, "shutdown");
    }
}

