/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.base.channel.in;

import java.util.ArrayList;
import java.util.List;
import risesoft.data.transfer.core.channel.AbstractInChannel;
import risesoft.data.transfer.core.context.JobContext;
import risesoft.data.transfer.core.record.Record;
import risesoft.data.transfer.core.util.Configuration;

public class BufferRecordInChannel
extends AbstractInChannel {
    private int bufferRecord;
    private List<Record> records;

    public BufferRecordInChannel(Configuration configuration, JobContext jobContext) {
        super(jobContext);
        this.bufferRecord = configuration.getInt("bufferRecord", 1024);
        this.records = new ArrayList<Record>(this.bufferRecord);
    }

    public void writer(Record record) {
        this.records.add(record);
        if (this.records.size() == this.bufferRecord) {
            this.flush();
        }
    }

    public void writer(List<Record> record) {
        for (Record record2 : record) {
            this.writer(record2);
        }
    }

    public void flush() {
        if (!this.records.isEmpty()) {
            this.recordOutuptStream.writer(this.records);
            this.records.clear();
        }
    }
}

