/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.utils;

import java.util.Collection;

public class Sqlbuilder {
    private StringBuilder builder;
    private static final int LENGTH = 24;
    private boolean hasWhere = false;
    private boolean hasOrder = false;

    public Sqlbuilder() {
        this(24);
    }

    public Sqlbuilder(StringBuilder builder) {
        this.builder = builder;
    }

    public StringBuilder getBuilder() {
        return this.builder;
    }

    public Sqlbuilder(int length) {
        this.builder = new StringBuilder(length);
    }

    public Sqlbuilder(String str) {
        this.builder = new StringBuilder(str);
    }

    public Sqlbuilder where(String condition) {
        if (this.hasWhere) {
            this.builder.append(" and " + condition);
        } else {
            this.builder.append(" where " + condition);
            this.hasWhere = true;
        }
        return this;
    }

    public Sqlbuilder order(String field) {
        if (this.hasOrder) {
            this.builder.append(" , " + field);
        } else {
            this.builder.append(" order by  " + field);
            this.hasOrder = true;
        }
        return this;
    }

    public Sqlbuilder in(Object[] values, boolean bracket) {
        if (bracket) {
            this.builder.append("(");
        }
        boolean flag = false;
        for (Object object : values) {
            if (flag) {
                this.builder.append(",?");
                continue;
            }
            flag = true;
            this.builder.append("?");
        }
        if (bracket) {
            this.builder.append(")");
        }
        return this;
    }

    public Sqlbuilder in(Collection values, boolean bracket) {
        if (bracket) {
            this.builder.append("(");
        }
        boolean flag = false;
        for (Object object : values) {
            if (flag) {
                this.builder.append(",?");
            } else {
                flag = true;
                this.builder.append("?");
            }
            this.builder.append(object);
        }
        if (bracket) {
            this.builder.append(")");
        }
        return this;
    }

    public String getWhereCondition() {
        return this.builder.length() > 0 ? this.builder.substring(7) : "";
    }

    public String toString() {
        return this.builder.toString();
    }
}

