/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.service.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.risedata.jdbc.commons.LPage;
import net.risedata.jdbc.executor.delete.DeleteExecutor;
import net.risedata.jdbc.executor.insert.InsertExecutor;
import net.risedata.jdbc.executor.search.SearchExecutor;
import net.risedata.jdbc.executor.update.UpdateExecutor;
import net.risedata.jdbc.operation.Operation;
import net.risedata.jdbc.search.LPageable;
import net.risedata.jdbc.service.CrudService;
import net.risedata.jdbc.utils.ClassUtils;
import org.springframework.transaction.annotation.Transactional;

public abstract class CrudServiceImpl<T, ID>
implements CrudService<T, ID> {
    Class<T> T = ClassUtils.getT(this);

    @Override
    public abstract SearchExecutor getSearchExecutor();

    @Override
    public abstract InsertExecutor getInsertExecutor();

    @Override
    public abstract DeleteExecutor getDeleteExecutor();

    @Override
    public abstract UpdateExecutor getUpdateExecutor();

    CrudServiceImpl() {
    }

    @Override
    @Transactional
    public int delete(T t) {
        return this.getDeleteExecutor().delete(t);
    }

    @Override
    @Transactional
    public int deleteByIds(ID ... ids) {
        return this.getDeleteExecutor().deleteByIds(this.T, ids);
    }

    @Override
    @Transactional
    public int deleteById(ID ... ids) {
        return this.getDeleteExecutor().deleteById(this.T, ids);
    }

    @Override
    public List<T> search(Map<String, Object> valueMap) {
        return this.getSearchExecutor().searchForList(this.T, null, valueMap, this.T);
    }

    @Override
    @Transactional
    public int delete(T t, Map<String, Object> values, Map<String, Operation> operation) {
        return this.getDeleteExecutor().delete(t, values, operation);
    }

    @Override
    public T findById(ID ... id) {
        return this.getSearchExecutor().findById(this.T, this.T, id);
    }

    @Override
    @Transactional
    public int delete(T t, Map<String, Operation> operation) {
        return this.getDeleteExecutor().delete(t, null, operation);
    }

    @Override
    public T findOne(T t) {
        return this.findOne(t, null, null);
    }

    @Override
    public T findOne(T t, Map<String, Object> valueMap, Map<String, Operation> operationMap) {
        return this.findOne(t, valueMap, operationMap, false);
    }

    @Override
    public T findOne(T t, Map<String, Object> valueMap, Map<String, Operation> operationMap, boolean isTransient) {
        return this.getSearchExecutor().findOne(t, valueMap, operationMap, isTransient, this.T);
    }

    @Override
    @Transactional
    public int save(T t) {
        if (this.getSearchExecutor().hasById(t, new Object[0])) {
            return this.getUpdateExecutor().updateById(t);
        }
        return this.getInsertExecutor().insert(t);
    }

    @Override
    @Transactional
    public int deleteById(ID id) {
        return this.getDeleteExecutor().deleteById(this.T, id);
    }

    @Override
    public boolean hasById(ID id) {
        return this.getSearchExecutor().hasById(this.T, id);
    }

    @Override
    public <E> E searchFieldById(String field, Class<E> class1, ID id) {
        return this.getSearchExecutor().searchFieldById(this.T, class1, field, id);
    }

    @Override
    public T getOne(ID id) {
        return this.getSearchExecutor().findById(this.T, this.T, id);
    }

    @Override
    public List<T> search(T entiry, Map<String, Object> valueMap, Map<String, Operation> operationMap) {
        return this.getSearchExecutor().searchForList(entiry, operationMap, valueMap, this.T);
    }

    @Override
    public List<T> search(T entiry, Map<String, Object> valueMap) {
        return this.getSearchExecutor().searchForList(entiry, null, valueMap, this.T);
    }

    @Override
    public List<T> search(T entiry) {
        return this.getSearchExecutor().searchForList(entiry, this.T);
    }

    @Override
    public LPage<T> searchForPage(T entiry, LPageable page, Map<String, Object> valueMap, Map<String, Operation> operationMap) {
        return this.getSearchExecutor().searchForPage(entiry, page, operationMap, valueMap, this.T);
    }

    @Override
    public LPage<T> searchAllForPage(T entiry, LPageable page, Map<String, Object> valueMap, Map<String, Operation> operationMap) {
        return this.getSearchExecutor().searchForPage(entiry, page, operationMap, valueMap, true, this.T);
    }

    @Override
    public LPage<T> searchForPage(T entiry, LPageable page, Map<String, Object> valueMap) {
        return this.getSearchExecutor().searchForPage(entiry, page, null, valueMap, this.T);
    }

    @Override
    public LPage<T> searchForPage(LPageable page) {
        return this.getSearchExecutor().searchForPage(this.T, page, this.T);
    }

    @Override
    public LPage<T> searchForPage(LPageable page, Map<String, Object> valueMap) {
        return this.searchForPage(null, page, valueMap, null);
    }

    @Override
    public LPage<T> searchAllForPage(LPageable page, Map<String, Object> valueMap) {
        return this.getSearchExecutor().searchForPage(this.T, null, page, null, valueMap, true, null, this.T);
    }

    @Override
    public LPage<T> searchAllForPage(LPageable page, Map<String, Object> valueMap, Map<String, Operation> omap) {
        return this.getSearchExecutor().searchForPage(this.T, null, page, omap, valueMap, true, null, this.T);
    }

    @Override
    public List<Map<String, Object>> searchForList(T t, String select) {
        return this.getSearchExecutor().searchForList(t, select);
    }

    @Override
    public List<Map<String, Object>> searchForList(T t, String select, Map<String, Operation> operationMap) {
        return this.getSearchExecutor().searchForList(t, select, operationMap);
    }

    @Override
    public LPage<T> searchForPage(T entiry, LPageable page) {
        return this.getSearchExecutor().searchForPage(entiry, page, this.T);
    }

    @Override
    @Transactional
    public int insert(T entiry) {
        return this.getInsertExecutor().insert(entiry);
    }

    @Override
    @Transactional
    public int batchInsert(Collection<T> entirys) {
        int[] res = this.getInsertExecutor().batchInsert(entirys);
        int count = 0;
        for (int i : res) {
            count += i;
        }
        return count;
    }

    @Override
    @Transactional
    public int updateById(T entiry) {
        return this.getUpdateExecutor().updateById(entiry);
    }

    @Override
    @Transactional
    public int updateById(T entiry, Map<String, Object> valueMap, Map<String, Operation> operation) {
        return this.getUpdateExecutor().updateById(entiry, valueMap, operation);
    }

    @Override
    @Transactional
    public int updateById(T entiry, Map<String, Operation> operation) {
        return this.getUpdateExecutor().updateById(entiry, null, operation);
    }

    @Override
    @Transactional
    public int update(T entiry, List<String> wheres) {
        return this.getUpdateExecutor().update(entiry, wheres);
    }

    @Override
    public List<T> search(String field, Map<String, Object> map, Map<String, Operation> operationMap) {
        return this.getSearchExecutor().searchForList(this.T, field, operationMap, map, null, this.T);
    }

    @Override
    public List<T> search(String field, Map<String, Object> map, Map<String, Operation> operationMap, boolean isOrder) {
        return this.getSearchExecutor().searchForList(this.T, field, operationMap, map, isOrder, this.T);
    }
}

