/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.search;

import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import net.risedata.jdbc.operation.Operation;
import net.risedata.jdbc.operation.SqlDefaultOperation;
import net.risedata.jdbc.operation.impl.DefaultOperation;
import net.risedata.jdbc.operation.impl.EQOperation;
import net.risedata.jdbc.operation.impl.InOperation;
import net.risedata.jdbc.operation.impl.LikeOperation;
import net.risedata.jdbc.operation.impl.NullOperation;

public class Operations {
    public static final Operation LIKE = new LikeOperation(true);
    public static final Operation NOTLIKE = new LikeOperation(false);
    public static final Operation EQ = new DefaultOperation("=");
    public static final Operation NOTEQ = new DefaultOperation("!=");
    public static final Operation GT = new DefaultOperation(">");
    public static final Operation LT = new DefaultOperation("<");
    public static final Operation GTANDEQ = new DefaultOperation(">=");
    public static final Operation LTANDGT = new DefaultOperation("<=");
    public static final Operation IN = new InOperation(true);
    public static final Operation NOTIN = new InOperation(false);
    public static final Operation PLACEHOLDER = new NullOperation();
    public static final List<SqlDefaultOperation> SQL_OPERATIONS = new ArrayList<SqlDefaultOperation>();

    @NotNull
    public static Operation getSqlTypeDefaultOperation(String type) {
        for (SqlDefaultOperation sqlDefaultOperation : SQL_OPERATIONS) {
            if (!sqlDefaultOperation.hasOperation(type)) continue;
            return sqlDefaultOperation.getOperation(type);
        }
        return null;
    }

    static {
        SQL_OPERATIONS.add((SqlDefaultOperation)((Object)LIKE));
        SQL_OPERATIONS.add(new EQOperation());
    }
}

