/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.repository.proxy;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javax.annotation.PostConstruct;
import net.risedata.jdbc.exception.ProxyException;
import net.risedata.jdbc.executor.jdbc.JdbcExecutor;
import net.risedata.jdbc.factory.InstanceFactoryManager;
import net.risedata.jdbc.factory.impl.SpringApplicationFactory;
import net.risedata.jdbc.repository.Repository;
import net.risedata.jdbc.repository.model.ClassBuild;
import net.risedata.jdbc.utils.ClassUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class RepositoryCreateFactory {
    public static final String JDBC_TEMPLATE = "$jt";
    private static final Random r = new Random();
    private static Map<Object, ClassBuild> instanceMap = new HashMap<Object, ClassBuild>();
    private static boolean isInitEd = false;
    @Autowired
    ApplicationContext ac;

    public static ClassBuild create(Class<?> sourceClass) {
        ClassPool pool = ClassPool.getDefault();
        pool.insertClassPath((ClassPath)new ClassClassPath(JdbcExecutor.class));
        try {
            ClassBuild properties = new ClassBuild(pool, pool.makeClass("LDynamicProxy$" + r.nextInt() + "@" + r.nextInt()), sourceClass, RepositoryCreateFactory.getGenerityClass(sourceClass), ClassUtils.getGenerityClasss(sourceClass));
            RepositoryCreateFactory.init(properties);
            return properties;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ProxyException(" create ClassBuilder error" + e.getMessage());
        }
    }

    private static Class<?> getGenerityClass(Class<?> sourceClass) throws ClassNotFoundException {
        if (Repository.class.isAssignableFrom(sourceClass)) {
            Type types = sourceClass.getGenericInterfaces()[0];
            if (types instanceof ParameterizedType) {
                Type genericType = ((ParameterizedType)types).getActualTypeArguments()[0];
                return Thread.currentThread().getContextClassLoader().loadClass(genericType.getTypeName());
            }
            return Object.class;
        }
        Class<?> generityClass = null;
        for (Class<?> interfaceItem : sourceClass.getInterfaces()) {
            if (!Repository.class.isAssignableFrom(interfaceItem)) continue;
            generityClass = RepositoryCreateFactory.getGenerityClass(interfaceItem);
            break;
        }
        return generityClass;
    }

    public static void init(ClassBuild classBuild) {
        classBuild.addField(JDBC_TEMPLATE, JdbcExecutor.class);
    }

    public static void instanceed(Object proxy, ClassBuild classBuild) {
        instanceMap.put(proxy, classBuild);
    }

    public static void startWeb(ApplicationContext ac) {
        InstanceFactoryManager.init(new SpringApplicationFactory(ac));
        if (instanceMap == null || instanceMap.size() <= 0) {
            return;
        }
        if (isInitEd) {
            return;
        }
        isInitEd = true;
        instanceMap.forEach((proxy, builder) -> {
            builder.putValue(JDBC_TEMPLATE, ac.getBean(JdbcExecutor.class));
            builder.createed(proxy);
            builder.getProxy().detach();
        });
    }

    @PostConstruct
    public void Initializing() {
        RepositoryCreateFactory.startWeb(this.ac);
    }
}

