/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.repository.parse.sql;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.risedata.jdbc.commons.exceptions.ParseException;
import net.risedata.jdbc.repository.model.ArgsBuilder;
import net.risedata.jdbc.repository.model.ReturnType;
import net.risedata.jdbc.repository.parse.sql.SqlParseHandle;
import net.risedata.jdbc.repository.parse.sql.handles.ArgsParseHandle;
import net.risedata.jdbc.repository.parse.sql.handles.ReplaceParseHandle;

public class SqlParseFactory {
    private static final List<SqlParseHandle> PARSE_HANDLES = new ArrayList<SqlParseHandle>();

    public static String parseSql(ReturnType type, Method m, ArgsBuilder args, String sourceSql) {
        List<String> instructions = SqlParseFactory.toInstructions(sourceSql);
        StringBuilder methodBody = new StringBuilder();
        StringBuilder sql = new StringBuilder(sourceSql);
        int find = 0;
        for (String instruction : instructions) {
            for (SqlParseHandle handle : PARSE_HANDLES) {
                if (!handle.isHandle(instruction)) continue;
                find = sql.indexOf(instruction);
                sql.replace(find, find + instruction.length(), handle.parse(m, type, args, instruction, methodBody));
            }
        }
        if (!args.isDynamic()) {
            methodBody.append("java.lang.String _sql = ").append('\"').append((CharSequence)sql).append('\"').append(";");
        } else {
            methodBody.insert(0, "java.lang.StringBuilder $sql = new java.lang.StringBuilder();");
            methodBody.append("$sql.append(").append('\"').append((CharSequence)sql).append('\"').append(");");
            methodBody.append("java.lang.String _sql = $sql.toString();");
        }
        return methodBody.toString();
    }

    private static List<String> toInstructions(String sourceSql) {
        ArrayList<String> instructions = new ArrayList<String>();
        int start = 0;
        int end = 0;
        int count = 0;
        int parsedCount = 0;
        while (start < sourceSql.length()) {
            if (sourceSql.charAt(start) == '?') {
                if (start + 1 < sourceSql.length() && SqlParseFactory.isNumber(sourceSql.charAt(start + 1))) {
                    if (count > 0) {
                        throw new ParseException("? ?index concurrence unidentifiable" + sourceSql);
                    }
                    for (end = start + 2; end < sourceSql.length() && SqlParseFactory.isNumber(sourceSql.charAt(end)); ++end) {
                    }
                    if (end > sourceSql.length()) {
                        throw new ParseException(sourceSql.substring(start, end) + " unidentifiable");
                    }
                    instructions.add(sourceSql.substring(start, end));
                    ++parsedCount;
                    start = end + 1;
                    continue;
                }
                if (parsedCount > 0) {
                    throw new ParseException("? ?index concurrence unidentifiable" + sourceSql);
                }
                ++count;
                ++start;
                continue;
            }
            if (sourceSql.charAt(start) == '#' && sourceSql.charAt(start + 1) == '{') {
                for (end = start + 2; end < sourceSql.length() && sourceSql.charAt(end) != '}'; ++end) {
                }
                if (end > sourceSql.length()) {
                    throw new ParseException(sourceSql.substring(start, end) + " unidentifiable");
                }
                instructions.add(sourceSql.substring(start, end + 1));
                start = end + 2;
                continue;
            }
            ++start;
        }
        return instructions;
    }

    private static boolean isNumber(char c) {
        return c > '/' && c < ':';
    }

    static {
        PARSE_HANDLES.add(new ArgsParseHandle());
        PARSE_HANDLES.add(new ReplaceParseHandle());
    }
}

