/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.repository.parse.handles.search;

import java.util.List;
import java.util.Map;
import net.risedata.jdbc.config.model.BeanConfig;
import net.risedata.jdbc.factory.BeanConfigFactory;
import net.risedata.jdbc.repository.model.ArgsBuilder;
import net.risedata.jdbc.repository.model.ClassBuild;
import net.risedata.jdbc.repository.model.ReturnType;
import net.risedata.jdbc.repository.parse.handles.search.SearchReturnHandle;

public class ListSearchReturnHandle
implements SearchReturnHandle {
    @Override
    public boolean isHandle(ReturnType type) {
        return type.getReturnType() == List.class;
    }

    @Override
    public String parse(ReturnType type, ClassBuild properties, ArgsBuilder argsBuilder) {
        if (type.isClass()) {
            BeanConfig bc = BeanConfigFactory.getInstance(type.getGenericityClass());
            if (bc == null) {
                if (type.getGenericityClass() == Map.class) {
                    return "return $jt.queryForListMap(_sql" + argsBuilder.to() + ");";
                }
                return "return $jt.queryForSimpleList(_sql, " + type.getGenericityClass().getName() + ".class" + argsBuilder.to() + ");";
            }
            return "return $jt.queryForList(_sql, " + type.getGenericityClass().getName() + ".class " + argsBuilder.to() + ");";
        }
        argsBuilder.delete(type.getIndex());
        return "return $jt.queryForList(_sql,(java.lang.Class)$args[" + type.getIndex() + "]" + argsBuilder.to() + ");";
    }
}

