/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.repository.parse.handles.method;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.risedata.jdbc.config.model.BeanConfig;
import net.risedata.jdbc.config.model.FieldConfig;
import net.risedata.jdbc.exception.ProxyException;
import net.risedata.jdbc.repository.model.ReturnType;
import net.risedata.jdbc.repository.parse.handles.method.InstructionManager;
import net.risedata.jdbc.utils.Sqlbuilder;

public class MethodNameBuilder {
    private Sqlbuilder sql = new Sqlbuilder();
    private String body = "";
    private List<String> instructions;
    private Method method;
    private int current = 0;
    private Map<Object, ParameterModel> parameterMap = new HashMap<Object, ParameterModel>();
    private BeanConfig beanConfig;
    private ReturnType returnType;

    public MethodNameBuilder(List<String> instructions, Parameter[] parameters, BeanConfig beanConfig, Method method, ReturnType returnType) {
        this.instructions = instructions;
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i].getName().equals("arg" + i)) {
                this.parameterMap.put(parameters[i].getParameterizedType().getTypeName().toLowerCase(), new ParameterModel(i + 1, parameters[i]));
                continue;
            }
            this.parameterMap.put(parameters[i].getName(), new ParameterModel(i + 1, parameters[i]));
        }
        this.beanConfig = beanConfig;
        this.method = method;
        this.returnType = returnType;
    }

    public Method getMethod() {
        return this.method;
    }

    public ReturnType getReturnType() {
        return this.returnType;
    }

    public MethodNameBuilder appendSql(String sql) {
        this.sql.getBuilder().append(sql);
        return this;
    }

    public Sqlbuilder getSqlbuilder() {
        return this.sql;
    }

    public String next() {
        return this.instructions.get(this.current++);
    }

    public MethodNameBuilder nextAndReturn() {
        ++this.current;
        return this;
    }

    public boolean hasNext() {
        return this.instructions.size() > this.current;
    }

    public String perviewNext() {
        return this.hasNext() ? this.instructions.get(this.current) : null;
    }

    public String next(boolean isInstruction, String defaultValue) {
        String next = this.perviewNext();
        if (InstructionManager.hasInstruction(next) == isInstruction) {
            return this.next();
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        throw new ProxyException("\u9700\u8981\u7684\u5b57\u6bb5\u4e3a\u6307\u4ee4 ? " + isInstruction + " \u5b9e\u9645:" + next);
    }

    public boolean concatParameter(String parameterKey) {
        return this.parameterMap.containsKey(parameterKey);
    }

    public Parameter getParameter(String parameterKey) {
        ParameterModel parameterModel = this.parameterMap.get(parameterKey);
        if (parameterModel == null) {
            throw new ProxyException("parameter is null" + parameterKey);
        }
        return parameterModel.parameter;
    }

    public ParameterModel getParameterModel(Object parameterKey) {
        ParameterModel parameterModel = this.parameterMap.get(parameterKey);
        if (parameterModel == null) {
            throw new ProxyException("parameter is null " + parameterKey);
        }
        return parameterModel;
    }

    public int getParameterIndex(String parameterKey) {
        return this.getParameterModel((Object)parameterKey).index;
    }

    public Parameter getParameterByIndex(int index) {
        return this.getParameterModel((Object)Integer.valueOf((int)index)).parameter;
    }

    public String getParameterArgs(String parameterKey) {
        ParameterModel model = this.parameterMap.get(parameterKey);
        if (model != null) {
            return "?" + model.index;
        }
        throw new ProxyException("parameter " + parameterKey + " is not found");
    }

    public String getBody() {
        return this.body;
    }

    public void appendBody(String body) {
        this.body = this.body + body;
    }

    public String getColumn(String backField) {
        FieldConfig fc = this.beanConfig.getField(backField);
        if (fc == null) {
            if ("id".equals(backField)) {
                List<FieldConfig> ids = this.beanConfig.getIdField();
                if (ids.size() < 1) {
                    return "";
                }
                return ids.get(0).getColumn();
            }
            throw new ProxyException("\u5b57\u6bb5\u4e0d\u5b58\u5728\u914d\u7f6e" + backField);
        }
        return fc.getColumn();
    }

    class ParameterModel {
        int index;
        Parameter parameter;

        public ParameterModel(int index, Parameter parameter) {
            this.index = index;
            this.parameter = parameter;
        }
    }
}

