/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.repository.parse.handles.method;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.risedata.jdbc.exception.ProxyException;
import net.risedata.jdbc.repository.parse.handles.method.InstructionHandle;
import net.risedata.jdbc.repository.parse.handles.method.order.OrderInstructionHandle;
import net.risedata.jdbc.repository.parse.handles.method.section.AllInstructionHandle;
import net.risedata.jdbc.repository.parse.handles.method.section.DistinctInstructionHandle;
import net.risedata.jdbc.repository.parse.handles.method.section.FieldInstructionHandle;
import net.risedata.jdbc.repository.parse.handles.method.started.DeleteInstructionHandle;
import net.risedata.jdbc.repository.parse.handles.method.started.SearchInstructionHandle;
import net.risedata.jdbc.repository.parse.handles.method.started.UpdateInstructionHandle;
import net.risedata.jdbc.repository.parse.handles.method.where.AndInstructionHandle;
import net.risedata.jdbc.repository.parse.handles.method.where.ByInstructionHandle;
import net.risedata.jdbc.repository.parse.handles.method.where.condition.BetweenInstructionHandle;
import net.risedata.jdbc.repository.parse.handles.method.where.condition.ContainingInstructionHandle;
import net.risedata.jdbc.repository.parse.handles.method.where.condition.EndingWithInstructionHandle;
import net.risedata.jdbc.repository.parse.handles.method.where.condition.FalseInstructionHandle;
import net.risedata.jdbc.repository.parse.handles.method.where.condition.IgnoreCaseInstructionHandle;
import net.risedata.jdbc.repository.parse.handles.method.where.condition.SimpledInstructionHandle;
import net.risedata.jdbc.repository.parse.handles.method.where.condition.StartingWithInstructionHandle;
import net.risedata.jdbc.repository.parse.handles.method.where.condition.TrueInstructionHandle;

public class InstructionManager {
    private static final Map<Class<? extends InstructionHandle>, Map<String, InstructionHandle>> INSTRUCTION_CLASS_MAP = new HashMap<Class<? extends InstructionHandle>, Map<String, InstructionHandle>>();
    private static final Map<String, InstructionHandle> INSTRUCTION_MAP = new HashMap<String, InstructionHandle>();

    public static void initInstruction(InstructionHandle instructionHandle) {
        String[] instructions = instructionHandle.handleInstruction().split(",");
        InstructionManager.putAll(instructions, INSTRUCTION_MAP, instructionHandle);
        List<Class<?>> classes = InstructionManager.getInterfaces(instructionHandle.getClass());
        for (Class<?> cla : classes) {
            if (!InstructionHandle.class.isAssignableFrom(cla)) continue;
            Map<String, InstructionHandle> instructionMap = INSTRUCTION_CLASS_MAP.get(cla);
            if (instructionMap == null) {
                instructionMap = new HashMap<String, InstructionHandle>();
                INSTRUCTION_CLASS_MAP.put(cla, instructionMap);
            }
            INSTRUCTION_CLASS_MAP.put(cla, instructionMap);
            InstructionManager.putAll(instructions, instructionMap, instructionHandle);
        }
    }

    private static void putAll(String[] instructions, Map<String, InstructionHandle> map, InstructionHandle instructionHandle) {
        for (int i = 0; i < instructions.length; ++i) {
            map.put(instructions[i], instructionHandle);
        }
    }

    private static List<Class<?>> getInterfaces(Class<?> cla) {
        ArrayList classes = new ArrayList();
        InstructionManager.loadInterfaces(cla, classes);
        return classes;
    }

    private static void loadInterfaces(Class<?> cla, List<Class<?>> classes) {
        if (cla != Object.class) {
            Class<?>[] classe;
            for (Class<?> class1 : classe = cla.getInterfaces()) {
                classes.add(class1);
            }
            InstructionManager.loadInterfaces(cla.getSuperclass(), classes);
        }
    }

    public static Map<String, InstructionHandle> get(Class<? extends InstructionHandle> instructionClass) {
        return INSTRUCTION_CLASS_MAP.get(instructionClass);
    }

    public static InstructionHandle get(Class<? extends InstructionHandle> instructionClass, String key, boolean required) {
        InstructionHandle instructionHandle = INSTRUCTION_CLASS_MAP.get(instructionClass).get(key);
        if (required && instructionHandle == null) {
            throw new ProxyException("\u672a\u8bc6\u522b\u7684\u6307\u4ee4:" + key);
        }
        return instructionHandle;
    }

    public static boolean hasInstruction(String key) {
        return INSTRUCTION_MAP.containsKey(key);
    }

    public static boolean hasInstruction(Class<? extends InstructionHandle> instructionClass, String key) {
        return INSTRUCTION_CLASS_MAP.get(instructionClass).containsKey(key);
    }

    public static InstructionHandle get(String key) {
        return INSTRUCTION_MAP.get(key);
    }

    public static boolean startsWith(String name) {
        Set<String> keys = INSTRUCTION_MAP.keySet();
        for (String key : keys) {
            if (!key.startsWith(name)) continue;
            return true;
        }
        return false;
    }

    static {
        InstructionManager.initInstruction(new FieldInstructionHandle());
        InstructionManager.initInstruction(new DistinctInstructionHandle());
        InstructionManager.initInstruction(new SearchInstructionHandle());
        InstructionManager.initInstruction(new DeleteInstructionHandle());
        InstructionManager.initInstruction(new UpdateInstructionHandle());
        InstructionManager.initInstruction(new BetweenInstructionHandle());
        InstructionManager.initInstruction(new SimpledInstructionHandle());
        InstructionManager.initInstruction(new ByInstructionHandle());
        InstructionManager.initInstruction(new OrderInstructionHandle());
        InstructionManager.initInstruction(new AndInstructionHandle());
        InstructionManager.initInstruction(new OrderInstructionHandle());
        InstructionManager.initInstruction(new StartingWithInstructionHandle());
        InstructionManager.initInstruction(new EndingWithInstructionHandle());
        InstructionManager.initInstruction(new TrueInstructionHandle());
        InstructionManager.initInstruction(new FalseInstructionHandle());
        InstructionManager.initInstruction(new IgnoreCaseInstructionHandle());
        InstructionManager.initInstruction(new ContainingInstructionHandle());
        InstructionManager.initInstruction(new AllInstructionHandle());
    }
}

