/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.repository.parse.handles;

import java.lang.reflect.Method;
import net.risedata.jdbc.annotations.repository.Modify;
import net.risedata.jdbc.commons.exceptions.ParseException;
import net.risedata.jdbc.repository.model.ArgsBuilder;
import net.risedata.jdbc.repository.model.ClassBuild;
import net.risedata.jdbc.repository.model.ReturnType;
import net.risedata.jdbc.repository.parse.MethodParseHandle;
import net.risedata.jdbc.repository.parse.sql.SqlParseFactory;
import org.springframework.core.annotation.AnnotationUtils;

public class UpdateParseHandle
implements MethodParseHandle {
    @Override
    public boolean isHandle(Method m) {
        return AnnotationUtils.findAnnotation((Method)m, Modify.class) != null;
    }

    @Override
    public String parse(Method m, ReturnType returnType, ClassBuild properties) {
        Modify modify = (Modify)AnnotationUtils.findAnnotation((Method)m, Modify.class);
        if (returnType.isVoid() || returnType.getReturnType() == Integer.TYPE || returnType.getReturnType() == Integer.class) {
            return UpdateParseHandle.parseBody(m, returnType, properties, modify.value());
        }
        throw new ParseException("modify return type unidentifiable " + m);
    }

    public static String parseBody(Method m, ReturnType returnType, ClassBuild properties, String sql) {
        ArgsBuilder args = new ArgsBuilder(m);
        StringBuilder body = new StringBuilder(SqlParseFactory.parseSql(returnType, m, args, sql));
        body.append(args.toBody());
        body.append(UpdateParseHandle.toReturn(returnType, args));
        return body.toString();
    }

    private static String toReturn(ReturnType type, ArgsBuilder argsBuilder) {
        return (type.isVoid() ? "" : (type.getReturnType() == Integer.TYPE ? "return ($r)" : "return ")) + "$jt.update(_sql" + argsBuilder.to() + ");";
    }
}

