/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.repository.parse.handles;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.risedata.jdbc.annotations.repository.Modify;
import net.risedata.jdbc.annotations.repository.Search;
import net.risedata.jdbc.factory.BeanConfigFactory;
import net.risedata.jdbc.repository.model.ClassBuild;
import net.risedata.jdbc.repository.model.ReturnType;
import net.risedata.jdbc.repository.parse.MethodParseHandle;
import net.risedata.jdbc.repository.parse.handles.method.InstructionManager;
import net.risedata.jdbc.repository.parse.handles.method.MethodNameBuilder;
import net.risedata.jdbc.repository.parse.handles.method.StartedInstructionHandle;
import net.risedata.jdbc.utils.FieldUtils;
import org.springframework.core.annotation.AnnotationUtils;

public class MethodNameParseHandle
implements MethodParseHandle {
    @Override
    public boolean isHandle(Method m) {
        return AnnotationUtils.findAnnotation((Method)m, Search.class) == null && AnnotationUtils.findAnnotation((Method)m, Modify.class) == null;
    }

    @Override
    public String parse(Method m, ReturnType returnType, ClassBuild properties) {
        MethodNameBuilder methodNameBuilder = new MethodNameBuilder(MethodNameParseHandle.createInstructions(m.getName(), FieldUtils.getFields(properties.getGenericityClass())), m.getParameters(), BeanConfigFactory.getInstance(properties.getGenericityClass()), m, returnType);
        InstructionManager.get(StartedInstructionHandle.class, methodNameBuilder.perviewNext(), true).handle(methodNameBuilder, properties);
        return methodNameBuilder.getBody();
    }

    private static boolean findParameter(List<Field> fields, String key, int i, String name) {
        key = FieldUtils.captureName(key);
        for (Field field : fields) {
            String sub;
            if (!field.getName().startsWith(key) || field.getName().length() == key.length() || i + (sub = field.getName().substring(key.length())).length() >= name.length()) continue;
            for (int j = 0; j < sub.length(); ++j) {
                if (sub.charAt(j) == name.charAt(i + j)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static List<String> createInstructions(String methodName, List<Field> fields) {
        ArrayList<String> instructions = new ArrayList<String>();
        int start = 0;
        for (int i = 0; i < methodName.length(); ++i) {
            String t;
            char tmp = methodName.charAt(i);
            if (!Character.isUpperCase(tmp) && tmp != '$' && i != methodName.length() - 1) continue;
            if (i == methodName.length() - 1) {
                ++i;
            }
            if (InstructionManager.hasInstruction(t = methodName.substring(start, i))) {
                instructions.add(methodName.substring(start, i));
            } else {
                if (InstructionManager.startsWith(t) || MethodNameParseHandle.findParameter(fields, t, i, methodName)) continue;
                instructions.add(FieldUtils.captureName(methodName.substring(start, i)));
            }
            start = i;
        }
        return instructions;
    }
}

