/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.repository.parse;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Map;
import net.risedata.jdbc.exception.InstanceException;
import net.risedata.jdbc.exception.ProxyException;
import net.risedata.jdbc.repository.model.ClassBuild;
import net.risedata.jdbc.repository.model.ReturnType;
import net.risedata.jdbc.repository.model.Type;
import net.risedata.jdbc.utils.GenerityModel;

public class ReturnTypeFactory {
    public static ReturnType parseInstance(Method m, ClassBuild methodClass) {
        String genericityName = m.getGenericReturnType().getTypeName();
        Class<?> returnType = m.getReturnType();
        if (returnType == Object.class) {
            int index;
            if (!genericityName.equals("java.lang.Object") && (index = ReturnTypeFactory.findT(genericityName, m)) != -1) {
                return new ReturnType(returnType, null, false, index);
            }
            Class<?> genericityClass = ReturnTypeFactory.getGenericityClass(m.getGenericReturnType().getTypeName(), m, methodClass);
            if (genericityClass != null) {
                return new ReturnType(genericityClass);
            }
            throw new ProxyException("An undefined type " + genericityName);
        }
        if (!genericityName.contains("java.util.Map")) {
            int end;
            int start = genericityName.indexOf("<");
            int n = end = start == -1 ? -1 : genericityName.indexOf(">");
            if (start != -1 && end != -1) {
                int index = ReturnTypeFactory.findT(genericityName = genericityName.substring(start + 1, end), m);
                if (index == -1) {
                    try {
                        Class<?> genericityClass = Class.forName(genericityName);
                        return new ReturnType(returnType, genericityClass);
                    }
                    catch (ClassNotFoundException e) {
                        Class<?> genericityClass = ReturnTypeFactory.getGenericityClass(genericityName, m, methodClass);
                        if (genericityClass != null) {
                            return new ReturnType(returnType, genericityClass);
                        }
                        throw new ProxyException("class not found " + e.getMessage());
                    }
                }
                return new ReturnType(returnType, null, false, index);
            }
        } else {
            return new ReturnType(returnType, Map.class);
        }
        return new ReturnType(returnType);
    }

    private static Class<?> getGenericityClass(String name, Method m, ClassBuild methodClass) {
        GenerityModel[] gm = methodClass.getGenerityModels().get(m.getDeclaringClass().getName());
        if (gm != null) {
            for (int i = 0; i < gm.length; ++i) {
                GenerityModel generityModel = gm[i];
                if (!generityModel.getName().equals(name)) continue;
                return generityModel.getGenerityClass();
            }
        }
        return null;
    }

    private static int findT(String genericityName, Method m) {
        Parameter[] ps = m.getParameters();
        for (int i = 0; i < ps.length; ++i) {
            if (!ps[i].getParameterizedType().getTypeName().contains("<" + genericityName + ">")) continue;
            return i;
        }
        return -1;
    }

    public static Type parseType(String sourceName) {
        block4: {
            try {
                int startIndex = sourceName.indexOf("<");
                if (startIndex != -1) {
                    int endIndex = sourceName.lastIndexOf(">");
                    if (endIndex != -1) {
                        String generalClassName = sourceName.substring(startIndex + 1, endIndex);
                        String className = sourceName.substring(0, startIndex);
                        return new Type(Thread.currentThread().getContextClassLoader().loadClass(className), Thread.currentThread().getContextClassLoader().loadClass(generalClassName));
                    }
                    break block4;
                }
                return new Type(Thread.currentThread().getContextClassLoader().loadClass(sourceName), null);
            }
            catch (Exception e) {
                throw new InstanceException(e.getMessage() + " \u65e0\u6cd5\u89e3\u6790sourceName " + sourceName);
            }
        }
        throw new InstanceException("\u65e0\u6cd5\u89e3\u6790sourceName " + sourceName);
    }
}

