/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.repository.parse;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.risedata.jdbc.repository.model.ClassBuild;
import net.risedata.jdbc.repository.model.ReturnType;
import net.risedata.jdbc.repository.parse.MethodParseHandle;
import net.risedata.jdbc.repository.parse.ReturnTypeFactory;
import net.risedata.jdbc.repository.parse.handles.MethodNameParseHandle;
import net.risedata.jdbc.repository.parse.handles.SearchParseHandle;
import net.risedata.jdbc.repository.parse.handles.UpdateParseHandle;

public class MethodParseFactory {
    private static List<MethodParseHandle> HANDLES = new ArrayList<MethodParseHandle>();

    public static String parseMethod(Method m, ClassBuild properties) {
        ReturnType returnType = ReturnTypeFactory.parseInstance(m, properties);
        for (MethodParseHandle methodParseHandle : HANDLES) {
            if (!methodParseHandle.isHandle(m)) continue;
            return methodParseHandle.parse(m, returnType, properties);
        }
        return null;
    }

    static {
        HANDLES.add(new SearchParseHandle());
        HANDLES.add(new UpdateParseHandle());
        HANDLES.add(new MethodNameParseHandle());
    }
}

