/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.repository.model;

import java.util.HashMap;
import java.util.Map;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import net.risedata.jdbc.exception.ProxyException;
import net.risedata.jdbc.utils.GenerityModel;

public class ClassBuild {
    private ClassPool pool;
    private CtClass proxy;
    private Map<String, GenerityModel[]> generityModels;
    private Class<?> sourceClass;
    private Class<?> genericityClass;
    private Map<String, Object> valueMap = new HashMap<String, Object>();

    public ClassBuild(ClassPool pool, CtClass proxy, Class<?> sourceClass, Class<?> genericityClass, Map<String, GenerityModel[]> generityModels) {
        this.pool = pool;
        this.proxy = proxy;
        this.sourceClass = sourceClass;
        this.genericityClass = genericityClass;
        this.generityModels = generityModels;
    }

    public Map<String, GenerityModel[]> getGenerityModels() {
        return this.generityModels;
    }

    public ClassBuild addField(String fieldName, Object value) {
        this.addField(fieldName, value.getClass());
        this.putValue(fieldName, value);
        return this;
    }

    public Class<?> getSourceClass() {
        return this.sourceClass;
    }

    public Class<?> getGenericityClass() {
        return this.genericityClass;
    }

    public void putValue(String fieldName, Object value) {
        this.valueMap.put(fieldName, value);
    }

    public void addField(String fieldName, Class<?> type) {
        try {
            CtClass jtType = this.pool.getCtClass(type.getName());
            CtField field = new CtField(jtType, fieldName, this.proxy);
            field.setModifiers(1);
            this.proxy.addField(field);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ProxyException(e.getMessage());
        }
    }

    public void createed(Object instance) {
        this.valueMap.forEach((k, v) -> {
            try {
                instance.getClass().getField((String)k).set(instance, v);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        });
    }

    public ClassPool getPool() {
        return this.pool;
    }

    public void setPool(ClassPool pool) {
        this.pool = pool;
    }

    public CtClass getProxy() {
        return this.proxy;
    }

    public void setProxy(CtClass proxy) {
        this.proxy = proxy;
    }

    public boolean hasField(String mappingName) {
        return this.valueMap.containsKey(mappingName);
    }
}

