/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.repository.model;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ArgsBuilder {
    private int[] deleteArgs;
    private List<String> args;
    private Method m;
    private StringBuilder body;
    private int index;
    public static final String ARGS_KEY = "$Largs";
    private static final String ARGS_INIT = "java.util.List $Largs =  new java.util.ArrayList();";

    public ArgsBuilder(Method m) {
        this.m = m;
    }

    public void add(String arg) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        this.args.add(arg);
    }

    public void delete(int index) {
        if (this.deleteArgs == null) {
            this.deleteArgs = new int[this.m.getParameterCount()];
        }
        this.deleteArgs[index] = 1;
    }

    public String to() {
        if (this.body != null) {
            return ",$Largs.toArray()";
        }
        if (this.args != null) {
            return ",new Object[]{" + StringUtils.join(this.args, (String)",") + "}";
        }
        if (this.deleteArgs != null) {
            StringBuilder argsBuilder = new StringBuilder();
            for (int i = 0; i < this.deleteArgs.length; ++i) {
                if (this.deleteArgs[i] == 1) continue;
                argsBuilder.append(",$args[" + i + "]");
            }
            if (argsBuilder.length() == 0) {
                return "";
            }
            return ",new Object[]{" + argsBuilder.substring(1, argsBuilder.length()) + "}";
        }
        return ",$args";
    }

    public String toBody() {
        if (this.body != null) {
            if (this.args != null) {
                for (int i = this.index; i < this.args.size(); ++i) {
                    this.addArg(this.args.get(i));
                }
            }
            return this.body.toString();
        }
        return "";
    }

    public ArgsBuilder appendArg(String arg) {
        this.initArgs();
        this.addArg(arg);
        return this;
    }

    public ArgsBuilder appendToBody(String b) {
        this.initArgs();
        this.body.append(b);
        return this;
    }

    public ArgsBuilder appendAllArg(String arg) {
        this.initArgs();
        this.addArgs(arg);
        return this;
    }

    private void initArgs() {
        if (this.body == null) {
            this.body = new StringBuilder(ARGS_INIT);
            if (this.args != null) {
                for (int i = 0; i < this.args.size(); ++i) {
                    this.appendArg(this.args.get(i));
                }
                this.index = this.args.size();
            }
        }
    }

    public void addArg(String arg) {
        this.body.append(ARGS_KEY).append(".add(").append(arg).append(");");
    }

    public void addArgs(String args) {
        this.body.append(ARGS_KEY).append(".addAll(").append(args).append(");");
    }

    public boolean isDynamic() {
        return this.body != null;
    }
}

