/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.repository;

import java.util.List;
import net.risedata.jdbc.commons.LogTime;
import net.risedata.jdbc.commons.utils.ClassTools;
import net.risedata.jdbc.config.EnableRepository;
import net.risedata.jdbc.factory.DynamicProxyFactory;
import net.risedata.jdbc.repository.Repository;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationUtils;

@Configuration
public class RepositoryManager
implements BeanFactoryPostProcessor {
    private static final Logger Log = LoggerFactory.getLogger(RepositoryManager.class);

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        String[] bootBean = beanFactory.getBeanNamesForAnnotation(EnableRepository.class);
        int count = 0;
        LogTime.start();
        for (int i = 0; i < bootBean.length; ++i) {
            String[] paths;
            Object boot = beanFactory.getBean(bootBean[i]);
            EnableRepository scan = (EnableRepository)AnnotationUtils.findAnnotation(boot.getClass(), EnableRepository.class);
            if (scan == null || !StringUtils.isNotBlank((CharSequence)scan.value()[0])) continue;
            for (String path : paths = scan.value()) {
                Object instance = null;
                List classs = ClassTools.getClasses((String)path);
                for (Class clas : classs) {
                    if (!clas.isInterface() || !Repository.class.isAssignableFrom(clas)) continue;
                    ++count;
                    instance = DynamicProxyFactory.getInstance(clas);
                    beanFactory.registerSingleton(clas.getSimpleName(), instance);
                    beanFactory.registerResolvableDependency(clas, instance);
                }
            }
        }
        Log.info("repository load " + count + " time:" + LogTime.get() + "ms");
    }
}

