/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.operation.impl;

import java.util.List;
import java.util.Map;
import net.risedata.jdbc.config.model.BeanConfig;
import net.risedata.jdbc.config.model.FieldConfig;
import net.risedata.jdbc.operation.Operation;
import net.risedata.jdbc.operation.SqlDefaultOperation;
import net.risedata.jdbc.operation.impl.SimpleOperation;

public class LikeOperation
extends SimpleOperation
implements SqlDefaultOperation {
    private String in = ">";

    public LikeOperation(boolean b) {
        if (!b) {
            this.in = " < ";
        }
    }

    @Override
    public boolean where(FieldConfig field, List<Object> args, StringBuilder sql, Map<String, Object> valueMap, BeanConfig bc, Map<String, Object> excludeMap) {
        Object ovalue = LikeOperation.getValue(field, valueMap);
        if (this.isNotNull(ovalue)) {
            args.add(ovalue);
            sql.append(" instr(" + field.getColumn() + ",?) " + this.in + " 0 ");
            return true;
        }
        return false;
    }

    public String toString() {
        return "likeOperation [like=" + this.in + "]";
    }

    @Override
    public int getOperate() {
        return 6;
    }

    @Override
    public boolean hasOperation(String sqlType) {
        String type = sqlType.toUpperCase();
        return type.indexOf("CHAR") != -1 || type.indexOf("BLOB") != -1;
    }

    @Override
    public Operation getOperation(String sqlType) {
        return this;
    }
}

