/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.jdbc.operation.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.risedata.jdbc.commons.TypeCheck;
import net.risedata.jdbc.config.model.BeanConfig;
import net.risedata.jdbc.config.model.FieldConfig;
import net.risedata.jdbc.factory.HandleMappingFactory;
import net.risedata.jdbc.operation.impl.SimpleOperation;

public class InOperation
extends SimpleOperation {
    private String in = "";
    private String eq = "";
    private boolean isIn = false;
    private Object val;

    public InOperation(boolean b) {
        if (b) {
            this.in = " IN ";
            this.eq = " = ?";
        } else {
            this.eq = " != ?";
            this.in = " NOT IN ";
        }
        this.isIn = b;
    }

    public InOperation(boolean b, Object val) {
        this(b);
        this.val = val;
    }

    @Override
    public boolean where(FieldConfig field, List<Object> args, StringBuilder sql, Map<String, Object> valueMap, BeanConfig bc, Map<String, Object> excludeMap) {
        Object ovalue;
        Object object = ovalue = this.val == null ? InOperation.getValue(field, valueMap) : this.val;
        if (this.isNotNull(ovalue)) {
            if (ovalue instanceof String) {
                String value = (String)ovalue;
                if (value.indexOf(",") != -1) {
                    Object[] values = value.split(",");
                    this.addArgs(values, args, sql, field);
                    return true;
                }
                args.add(ovalue);
                if (this.isIn) {
                    sql.append(field.getColumn() + this.eq);
                } else {
                    sql.append(field.getColumn() + this.eq);
                }
                return true;
            }
            if (ovalue.getClass().isArray()) {
                Object[] oarr = (Object[])ovalue;
                this.addArgs(oarr, args, sql, field);
                return true;
            }
            if (Iterable.class.isAssignableFrom(ovalue.getClass())) {
                Iterator iterator = ((Iterable)ovalue).iterator();
                sql.append(field.getColumn() + this.in + "(");
                while (iterator.hasNext()) {
                    args.add(HandleMappingFactory.parse(iterator.next(), field.getFieldType()));
                    if (iterator.hasNext()) {
                        sql.append("?,");
                        continue;
                    }
                    sql.append("?)");
                }
                return true;
            }
            if (TypeCheck.isNumber(ovalue.getClass())) {
                args.add(ovalue);
                sql.append(field.getColumn() + this.eq);
                return true;
            }
            args.add(ovalue);
            sql.append(field.getColumn() + this.in + "(?)");
            return true;
        }
        return false;
    }

    private void addArgs(Object[] arr, List<Object> args, StringBuilder sql, FieldConfig field) {
        if (arr.length == 1) {
            args.add(HandleMappingFactory.parse(arr[0], field.getFieldType()));
            if (this.isIn) {
                sql.append(field.getColumn() + this.eq);
            } else {
                sql.append(field.getColumn() + this.eq);
            }
        } else {
            sql.append(field.getColumn() + this.in + "(");
            for (int i = 0; i < arr.length; ++i) {
                args.add(HandleMappingFactory.parse(arr[i], field.getFieldType()));
                if (i == arr.length - 1) {
                    sql.append("?)");
                    continue;
                }
                sql.append("?,");
            }
        }
    }

    public String toString() {
        return "InOperation [in=" + this.in + "]";
    }

    @Override
    public int getOperate() {
        return 4;
    }
}

